/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.render;

import io.takari.graph.DependencyGraph;
import io.takari.graph.render.GraphRenderer;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class D3GraphRenderer<V>
implements GraphRenderer<V> {
    private final int INDENT = 2;

    @Override
    public void render(DependencyGraph<V> g, OutputStream os) {
        V root = g.getRoot();
        int indent = 0;
        PrintWriter out = new PrintWriter(os);
        this.renderVertex(g, root, out, true, indent);
        out.flush();
    }

    private void renderVertex(DependencyGraph<V> graph, V vertex, PrintWriter writer, boolean isLast, int indent) {
        writer.print(this.indent(indent));
        writer.print(String.format("{ \"name\": \"%s\"", vertex));
        List<V> edges = graph.getDirectUpstream(vertex);
        if (!edges.isEmpty()) {
            writer.println(",");
            writer.print(this.indent(indent += 2));
            writer.println("\"children\": [");
            int i = 0;
            Iterator<V> i$ = edges.iterator();
            while (i$.hasNext()) {
                V e;
                V child = e = i$.next();
                this.renderVertex(graph, child, writer, i == edges.size() - 1, indent + 2);
                ++i;
            }
            writer.print(this.indent(indent));
            writer.println("]");
            writer.print(this.indent(indent -= 2));
        }
        if (isLast) {
            writer.println("}");
        } else {
            writer.println(" },");
        }
    }

    private String indent(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

