/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.render;

import io.takari.graph.Dependency;
import io.takari.graph.DependencyGraph;
import io.takari.graph.render.DotConstants;
import io.takari.graph.render.GraphRenderer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.codehaus.plexus.util.StringUtils;

public class DotGraphRenderer<V>
implements GraphRenderer<V> {
    public static final String INDENT = "  ";
    private String graphName = "G";
    private DotConstants.DotGraphType graphType = DotConstants.DotGraphType.DIGRAPH;

    @Override
    public void render(DependencyGraph<V> graph, OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(os);
        String name = this.getDotSafeName(this.graphName);
        this.write(String.format("%s %s {%n", this.graphType.getName(), name), writer);
        for (V v : graph.getDependencyNodes()) {
            String id = "" + v.toString();
            String label = id;
            if (StringUtils.isBlank((String)label)) {
                label = v.toString();
            }
            this.write(String.format("%s%s;%n", INDENT, this.getDotSafeName(id)), writer);
        }
        for (Dependency dependency : graph.getDependencies()) {
            String source = dependency.getSource().toString();
            String target = dependency.getTarget().toString();
            this.write(String.format("%s%s%s%s;%n", INDENT, this.getDotSafeName(source), this.graphType.getEdge(), this.getDotSafeName(target)), writer);
        }
        this.write("}", writer);
        writer.close();
    }

    private String getDotSafeName(String inName) {
        String name = null;
        name = StringUtils.isAlphanumeric((String)inName) ? inName : "\"" + inName + "\"";
        return name;
    }

    private void write(String s, PrintWriter os) throws IOException {
        os.write(s);
    }
}

