/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.FileMode;
import io.tesla.proviso.archive.Selector;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.UnarchivingEntryProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class UnArchiver {
    private final Selector selector;
    private final boolean useRoot;
    private final boolean flatten;

    public UnArchiver(List<String> includes, List<String> excludes, boolean useRoot, boolean flatten) {
        this.useRoot = useRoot;
        this.flatten = flatten;
        this.selector = new Selector(includes, excludes);
    }

    public void unarchive(File archive, File outputDirectory) throws IOException {
        this.unarchive(archive, outputDirectory, new NoopEntryProcessor());
    }

    public void unarchive(File archive, File outputDirectory, UnarchivingEntryProcessor entryProcessor) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        Source source = ArchiverHelper.getArchiveHandler(archive).getArchiveSource();
        for (Entry archiveEntry : source.entries()) {
            String entryName = archiveEntry.getName();
            if (!this.useRoot) {
                entryName = entryName.substring(entryName.indexOf(47) + 1);
            }
            if (!this.selector.include(entryName)) continue;
            entryName = entryProcessor.processName(entryName);
            if (this.flatten) {
                entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
            } else if (archiveEntry.isDirectory()) {
                this.createDir(new File(outputDirectory, entryName));
                continue;
            }
            File outputFile = new File(outputDirectory, entryName);
            if (outputFile.getAbsolutePath().equals(outputDirectory.getAbsolutePath())) continue;
            if (!outputFile.getParentFile().exists()) {
                this.createDir(outputFile.getParentFile());
            }
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                entryProcessor.processStream(archiveEntry.getName(), archiveEntry.getInputStream(), outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int mode = archiveEntry.getFileMode();
            if (mode == -1) continue;
            try {
                Files.setPosixFilePermissions(outputFile.toPath(), FileMode.toPermissionsSet(mode));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        source.close();
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static UnArchiverBuilder builder() {
        return new UnArchiverBuilder();
    }

    class NoopEntryProcessor
    implements UnarchivingEntryProcessor {
        NoopEntryProcessor() {
        }

        @Override
        public String processName(String entryName) {
            return entryName;
        }

        @Override
        public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public static class UnArchiverBuilder {
        private List<String> includes = new ArrayList<String>();
        private List<String> excludes = new ArrayList<String>();
        private boolean useRoot = true;
        private boolean flatten = false;

        public UnArchiverBuilder includes(String ... includes) {
            ArrayList i = Lists.newArrayList();
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String include = stringArray[n2];
                if (include != null) {
                    i.add(include);
                }
                ++n2;
            }
            return this.includes((Iterable<String>)ImmutableList.copyOf((Collection)i));
        }

        public UnArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public UnArchiverBuilder excludes(String ... excludes) {
            ArrayList i = Lists.newArrayList();
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                if (exclude != null) {
                    i.add(exclude);
                }
                ++n2;
            }
            return this.excludes((Iterable<String>)ImmutableList.copyOf((Collection)i));
        }

        public UnArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public UnArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public UnArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public UnArchiver build() {
            return new UnArchiver(this.includes, this.excludes, this.useRoot, this.flatten);
        }
    }
}

