/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.EncodingKeys;
import io.temporal.common.converter.PayloadConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public final class ProtobufJsonPayloadConverter
implements PayloadConverter {
    private final JsonFormat.Printer printer;
    private final JsonFormat.Parser parser;

    public ProtobufJsonPayloadConverter() {
        this.printer = JsonFormat.printer().preservingProtoFieldNames();
        this.parser = JsonFormat.parser().ignoringUnknownFields();
    }

    public ProtobufJsonPayloadConverter(JsonFormat.Printer printer, JsonFormat.Parser parser) {
        this.printer = Objects.requireNonNull(printer);
        this.parser = Objects.requireNonNull(parser);
    }

    @Override
    public String getEncodingType() {
        return "json/protobuf";
    }

    @Override
    public Optional<Payload> toData(Object value) throws DataConverterException {
        if (!(value instanceof MessageOrBuilder)) {
            return Optional.empty();
        }
        JsonFormat.Printer printer = JsonFormat.printer();
        try {
            String data = printer.print((MessageOrBuilder)value);
            return Optional.of(Payload.newBuilder().putMetadata("encoding", EncodingKeys.METADATA_ENCODING_PROTOBUF_JSON).setData(ByteString.copyFrom((String)data, (Charset)StandardCharsets.UTF_8)).build());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromData(Payload content, Class<T> valueClass, Type valueType) throws DataConverterException {
        ByteString data = content.getData();
        if (!MessageOrBuilder.class.isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException("Not a protobuf. valueClass=" + valueClass.getName());
        }
        try {
            Method toBuilder = valueClass.getMethod("newBuilder", new Class[0]);
            Message.Builder builder = (Message.Builder)toBuilder.invoke(null, new Object[0]);
            this.parser.merge(data.toString(StandardCharsets.UTF_8), builder);
            return (T)builder.build();
        }
        catch (Exception e) {
            throw new DataConverterException(e);
        }
    }
}

