/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.worker.Shutdownable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class InternalUtils {
    public static TaskQueue createStickyTaskQueue(String taskQueueName) {
        return TaskQueue.newBuilder().setName(taskQueueName).setKind(TaskQueueKind.TASK_QUEUE_KIND_STICKY).build();
    }

    public static TaskQueue createNormalTaskQueue(String taskQueueName) {
        return TaskQueue.newBuilder().setName(taskQueueName).setKind(TaskQueueKind.TASK_QUEUE_KIND_NORMAL).build();
    }

    public static long awaitTermination(Shutdownable s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return InternalUtils.awaitTermination(timeoutMillis, () -> s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    public static long awaitTermination(ExecutorService s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return InternalUtils.awaitTermination(timeoutMillis, () -> {
            try {
                s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static long awaitTermination(long timeoutMillis, Runnable toTerminate) {
        long started = System.currentTimeMillis();
        toTerminate.run();
        long remainingTimeout = timeoutMillis - (System.currentTimeMillis() - started);
        if (remainingTimeout < 0L) {
            remainingTimeout = 0L;
        }
        return remainingTimeout;
    }

    public static Object getValueOrDefault(Object value, Class<?> valueClass) {
        if (value != null) {
            return value;
        }
        return Defaults.defaultValue(valueClass);
    }

    public static SearchAttributes convertMapToSearchAttributes(Map<String, Object> searchAttributes, DataConverter converter) {
        HashMap mapOfByteBuffer = new HashMap();
        searchAttributes.forEach((key, value) -> mapOfByteBuffer.put(key, converter.toPayload(value).get()));
        return SearchAttributes.newBuilder().putAllIndexedFields(mapOfByteBuffer).build();
    }

    private InternalUtils() {
    }
}

