/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.external;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.GrpcRetryer;
import io.temporal.internal.common.SignalWithStartWorkflowExecutionParameters;
import io.temporal.internal.external.GenericWorkflowClientExternal;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public final class GenericWorkflowClientExternalImpl
implements GenericWorkflowClientExternal {
    private final String namespace;
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;
    private final String identity;

    public GenericWorkflowClientExternalImpl(WorkflowServiceStubs service, String namespace, String identity, Scope metricsScope) {
        this.service = service;
        this.namespace = namespace;
        this.identity = identity;
        this.metricsScope = metricsScope;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public WorkflowServiceStubs getService() {
        return this.service;
    }

    @Override
    public WorkflowExecution start(StartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        StartWorkflowExecutionResponse result = GrpcRetryer.retryWithResult(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).startWorkflowExecution(request));
        return WorkflowExecution.newBuilder().setRunId(result.getRunId()).setWorkflowId(request.getWorkflowId()).build();
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWorkflowExecution(request));
    }

    @Override
    public WorkflowExecution signalWithStart(SignalWithStartWorkflowExecutionParameters parameters) {
        String workflowId;
        StartWorkflowExecutionRequest startParameters = parameters.getStartParameters();
        SignalWithStartWorkflowExecutionRequest.Builder request = SignalWithStartWorkflowExecutionRequest.newBuilder().setNamespace(this.namespace).setRequestId(this.generateUniqueId()).setIdentity(this.identity).setSignalName(parameters.getSignalName()).setWorkflowRunTimeout(startParameters.getWorkflowRunTimeout()).setWorkflowExecutionTimeout(startParameters.getWorkflowExecutionTimeout()).setWorkflowTaskTimeout(startParameters.getWorkflowTaskTimeout()).setWorkflowType(startParameters.getWorkflowType()).setWorkflowIdReusePolicy(startParameters.getWorkflowIdReusePolicy()).setCronSchedule(startParameters.getCronSchedule());
        Optional<Payloads> signalInput = parameters.getSignalInput();
        if (signalInput.isPresent()) {
            request.setSignalInput(signalInput.get());
        }
        if (startParameters.hasInput()) {
            request.setInput(startParameters.getInput());
        }
        if (startParameters.hasTaskQueue()) {
            request.setTaskQueue(startParameters.getTaskQueue());
        }
        if ((workflowId = startParameters.getWorkflowId()).isEmpty()) {
            workflowId = this.generateUniqueId();
        }
        request.setWorkflowId(workflowId);
        if (startParameters.hasRetryPolicy()) {
            request.setRetryPolicy(startParameters.getRetryPolicy());
        }
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        SignalWithStartWorkflowExecutionResponse result = GrpcRetryer.retryWithResult(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWithStartWorkflowExecution(request.build()));
        return WorkflowExecution.newBuilder().setRunId(result.getRunId()).setWorkflowId(request.getWorkflowId()).build();
    }

    @Override
    public void requestCancel(RequestCancelWorkflowExecutionRequest request) {
        GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).requestCancelWorkflowExecution(request));
    }

    @Override
    public void terminate(TerminateWorkflowExecutionRequest request) {
        GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).terminateWorkflowExecution(request));
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryParameters) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"query_type", (Object)queryParameters.getQuery().getQueryType()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return GrpcRetryer.retryWithResult(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).queryWorkflow(queryParameters));
    }

    @Override
    public String generateUniqueId() {
        return UUID.randomUUID().toString();
    }
}

