/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import io.temporal.api.command.v1.Command;
import io.temporal.api.query.v1.WorkflowQueryResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WorkflowTaskResult {
    private final List<Command> commands;
    private final boolean finalCommand;
    private final Map<String, WorkflowQueryResult> queryResults;
    private final boolean forceWorkflowTask;

    public static Builder newBuilder() {
        return new Builder();
    }

    private WorkflowTaskResult(List<Command> commands, Map<String, WorkflowQueryResult> queryResults, boolean finalCommand, boolean forceWorkflowTask) {
        this.commands = commands;
        if (forceWorkflowTask && finalCommand) {
            throw new IllegalArgumentException("both forceWorkflowTask and finalCommand are true");
        }
        this.queryResults = queryResults;
        this.finalCommand = finalCommand;
        this.forceWorkflowTask = forceWorkflowTask;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public Map<String, WorkflowQueryResult> getQueryResults() {
        return this.queryResults;
    }

    public boolean isFinalCommand() {
        return this.finalCommand;
    }

    public boolean isForceWorkflowTask() {
        return this.forceWorkflowTask;
    }

    public static final class Builder {
        private List<Command> commands;
        private boolean finalCommand;
        private Map<String, WorkflowQueryResult> queryResults;
        private boolean forceWorkflowTask;

        public Builder setCommands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public Builder setFinalCommand(boolean finalCommand) {
            this.finalCommand = finalCommand;
            return this;
        }

        public Builder setQueryResults(Map<String, WorkflowQueryResult> queryResults) {
            this.queryResults = queryResults;
            return this;
        }

        public Builder setForceWorkflowTask(boolean forceWorkflowTask) {
            this.forceWorkflowTask = forceWorkflowTask;
            return this;
        }

        public WorkflowTaskResult build() {
            return new WorkflowTaskResult(this.commands == null ? Collections.emptyList() : this.commands, this.queryResults == null ? Collections.emptyMap() : this.queryResults, this.finalCommand, this.forceWorkflowTask);
        }
    }
}

