/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Strings;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.errordetails.v1.QueryFailedFailure;
import io.temporal.api.errordetails.v1.WorkflowExecutionAlreadyStartedFailure;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowException;
import io.temporal.client.WorkflowExecutionAlreadyStarted;
import io.temporal.client.WorkflowFailedException;
import io.temporal.client.WorkflowNotFoundException;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowQueryException;
import io.temporal.client.WorkflowQueryRejectedException;
import io.temporal.client.WorkflowServiceException;
import io.temporal.client.WorkflowStub;
import io.temporal.common.RetryOptions;
import io.temporal.common.context.ContextPropagator;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.common.CheckedExceptionWrapper;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.SignalWithStartWorkflowExecutionParameters;
import io.temporal.internal.common.StatusUtils;
import io.temporal.internal.common.WorkflowExecutionFailedException;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.external.GenericWorkflowClientExternal;
import io.temporal.internal.sync.SyncWorkflowContext;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

class WorkflowStubImpl
implements WorkflowStub {
    private final GenericWorkflowClientExternal genericClient;
    private final Optional<String> workflowType;
    private final Scope metricsScope;
    private final AtomicReference<WorkflowExecution> execution = new AtomicReference();
    private final Optional<WorkflowOptions> options;
    private final WorkflowClientOptions clientOptions;

    WorkflowStubImpl(WorkflowClientOptions clientOptions, GenericWorkflowClientExternal genericClient, Optional<String> workflowType, WorkflowExecution execution, Scope metricsScope) {
        this.clientOptions = clientOptions;
        this.genericClient = genericClient;
        this.workflowType = workflowType;
        this.metricsScope = metricsScope;
        if (execution == null || execution.getWorkflowId() == null || execution.getWorkflowId().isEmpty()) {
            throw new IllegalArgumentException("null or empty workflowId");
        }
        this.execution.set(execution);
        this.options = Optional.empty();
    }

    WorkflowStubImpl(WorkflowClientOptions clientOptions, GenericWorkflowClientExternal genericClient, String workflowType, WorkflowOptions options, Scope metricsScope) {
        this.clientOptions = clientOptions;
        this.genericClient = genericClient;
        this.workflowType = Optional.of(workflowType);
        this.metricsScope = metricsScope;
        this.options = Optional.of(options);
    }

    @Override
    public void signal(String signalName, Object ... args) {
        Optional<Payloads> input;
        this.checkStarted();
        SignalWorkflowExecutionRequest.Builder request = SignalWorkflowExecutionRequest.newBuilder().setSignalName(signalName).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(this.execution.get().getWorkflowId()));
        if (this.clientOptions.getIdentity() != null) {
            request.setIdentity(this.clientOptions.getIdentity());
        }
        if (this.clientOptions.getNamespace() != null) {
            request.setNamespace(this.clientOptions.getNamespace());
        }
        if ((input = this.clientOptions.getDataConverter().toPayloads(args)).isPresent()) {
            request.setInput(input.get());
        }
        try {
            this.genericClient.signal(request.build());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw new WorkflowNotFoundException(this.execution.get(), this.workflowType.orElse(null));
            }
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
    }

    private WorkflowExecution startWithOptions(WorkflowOptions o, Object ... args) {
        StartWorkflowExecutionRequest request = this.newStartWorkflowExecutionRequest(o, args);
        try {
            this.execution.set(this.genericClient.start(request));
        }
        catch (StatusRuntimeException e) {
            WorkflowExecutionAlreadyStartedFailure f = StatusUtils.getFailure(e, WorkflowExecutionAlreadyStartedFailure.class);
            if (f != null) {
                WorkflowExecution exe = WorkflowExecution.newBuilder().setWorkflowId(request.getWorkflowId()).setRunId(f.getRunId()).build();
                this.execution.set(exe);
                throw new WorkflowExecutionAlreadyStarted(exe, this.workflowType.get(), e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
        return this.execution.get();
    }

    private StartWorkflowExecutionRequest newStartWorkflowExecutionRequest(WorkflowOptions o, Object[] args) {
        String workflowId;
        String taskQueue;
        if (this.execution.get() != null) {
            throw new IllegalStateException("Cannot reuse a stub instance to start more than one workflow execution. The stub points to already started execution. If you are trying to wait for a workflow completion either change WorkflowIdReusePolicy from AllowDuplicate or use WorkflowStub.getResult");
        }
        StartWorkflowExecutionRequest.Builder request = StartWorkflowExecutionRequest.newBuilder().setWorkflowType(WorkflowType.newBuilder().setName(this.workflowType.get())).setRequestId(UUID.randomUUID().toString()).setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration(o.getWorkflowRunTimeout())).setWorkflowExecutionTimeout(ProtobufTimeUtils.toProtoDuration(o.getWorkflowExecutionTimeout())).setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration(o.getWorkflowTaskTimeout()));
        if (this.clientOptions.getIdentity() != null) {
            request.setIdentity(this.clientOptions.getIdentity());
        }
        if (this.clientOptions.getNamespace() != null) {
            request.setNamespace(this.clientOptions.getNamespace());
        }
        if (o.getWorkflowId() == null) {
            request.setWorkflowId(UUID.randomUUID().toString());
        } else {
            request.setWorkflowId(o.getWorkflowId());
        }
        Optional<Payloads> input = this.clientOptions.getDataConverter().toPayloads(args);
        if (input.isPresent()) {
            request.setInput(input.get());
        }
        if (o.getWorkflowIdReusePolicy() != null) {
            request.setWorkflowIdReusePolicy(o.getWorkflowIdReusePolicy());
        }
        if ((taskQueue = o.getTaskQueue()) != null && !taskQueue.isEmpty()) {
            request.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue).build());
        }
        if ((workflowId = o.getWorkflowId()) == null) {
            workflowId = UUID.randomUUID().toString();
        }
        request.setWorkflowId(workflowId);
        RetryOptions retryOptions = o.getRetryOptions();
        if (retryOptions != null) {
            request.setRetryPolicy(SyncWorkflowContext.toRetryPolicy(retryOptions));
        }
        if (!Strings.isNullOrEmpty((String)o.getCronSchedule())) {
            request.setCronSchedule(o.getCronSchedule());
        }
        if (o.getMemo() != null) {
            request.setMemo(Memo.newBuilder().putAllFields(this.convertMemoFromObjectToBytes(o.getMemo())));
        }
        if (o.getSearchAttributes() != null) {
            request.setSearchAttributes(SearchAttributes.newBuilder().putAllIndexedFields(this.convertMemoFromObjectToBytes(o.getSearchAttributes())));
        }
        if (o.getContextPropagators() != null && !o.getContextPropagators().isEmpty()) {
            Map<String, Payload> context = this.extractContextsAndConvertToBytes(o.getContextPropagators());
            request.setHeader(Header.newBuilder().putAllFields(context));
        }
        return request.build();
    }

    private Map<String, Payload> convertMemoFromObjectToBytes(Map<String, Object> map) {
        return HeaderUtils.convertMapFromObjectToBytes(map, this.clientOptions.getDataConverter());
    }

    private Map<String, Payload> convertSearchAttributesFromObjectToBytes(Map<String, Object> map) {
        return HeaderUtils.convertMapFromObjectToBytes(map, this.clientOptions.getDataConverter());
    }

    private Map<String, Payload> extractContextsAndConvertToBytes(List<ContextPropagator> contextPropagators) {
        if (contextPropagators == null) {
            return null;
        }
        HashMap<String, Payload> result = new HashMap<String, Payload>();
        for (ContextPropagator propagator : contextPropagators) {
            result.putAll(propagator.serializeContext(propagator.getCurrentContext()));
        }
        return result;
    }

    @Override
    public WorkflowExecution start(Object ... args) {
        if (!this.options.isPresent()) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        return this.startWithOptions(WorkflowOptions.merge(null, null, this.options.get()), args);
    }

    private WorkflowExecution signalWithStartWithOptions(WorkflowOptions options, String signalName, Object[] signalArgs, Object[] startArgs) {
        StartWorkflowExecutionRequest request = this.newStartWorkflowExecutionRequest(options, startArgs);
        Optional<Payloads> signalInput = this.clientOptions.getDataConverter().toPayloads(signalArgs);
        SignalWithStartWorkflowExecutionParameters p = new SignalWithStartWorkflowExecutionParameters(request, signalName, signalInput);
        try {
            this.execution.set(this.genericClient.signalWithStart(p));
        }
        catch (StatusRuntimeException e) {
            WorkflowExecutionAlreadyStartedFailure f = StatusUtils.getFailure(e, WorkflowExecutionAlreadyStartedFailure.class);
            if (f != null) {
                WorkflowExecution exe = WorkflowExecution.newBuilder().setWorkflowId(request.getWorkflowId()).setRunId(f.getRunId()).build();
                this.execution.set(exe);
                throw new WorkflowExecutionAlreadyStarted(exe, this.workflowType.get(), e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
        return this.execution.get();
    }

    @Override
    public WorkflowExecution signalWithStart(String signalName, Object[] signalArgs, Object[] startArgs) {
        if (!this.options.isPresent()) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        return this.signalWithStartWithOptions(WorkflowOptions.merge(null, null, this.options.get()), signalName, signalArgs, startArgs);
    }

    @Override
    public Optional<String> getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution.get();
    }

    @Override
    public <R> R getResult(Class<R> resultClass) {
        return this.getResult(resultClass, resultClass);
    }

    @Override
    public <R> R getResult(Class<R> resultClass, Type resultType) {
        try {
            return this.getResult(Integer.MAX_VALUE, TimeUnit.MILLISECONDS, resultClass, resultType);
        }
        catch (TimeoutException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
    }

    @Override
    public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass) throws TimeoutException {
        return this.getResult(timeout, unit, resultClass, resultClass);
    }

    @Override
    public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) throws TimeoutException {
        this.checkStarted();
        try {
            Optional<Payloads> resultValue = WorkflowExecutionUtils.getWorkflowExecutionResult(this.genericClient.getService(), this.genericClient.getNamespace(), this.execution.get(), this.workflowType, this.metricsScope, this.clientOptions.getDataConverter(), timeout, unit);
            return this.clientOptions.getDataConverter().fromPayloads(0, resultValue, resultClass, resultType);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            return this.mapToWorkflowFailureException(e, resultClass);
        }
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass) {
        return this.getResultAsync(resultClass, resultClass);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass, Type resultType) {
        return this.getResultAsync(Long.MAX_VALUE, TimeUnit.MILLISECONDS, resultClass, resultType);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass) {
        return this.getResultAsync(timeout, unit, resultClass, resultClass);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) {
        this.checkStarted();
        return WorkflowExecutionUtils.getWorkflowExecutionResultAsync(this.genericClient.getService(), this.genericClient.getNamespace(), this.execution.get(), this.workflowType, timeout, unit, this.clientOptions.getDataConverter()).handle((r, e) -> {
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof WorkflowExecutionFailedException) {
                return this.mapToWorkflowFailureException((WorkflowExecutionFailedException)e, resultClass);
            }
            if (e != null) {
                throw CheckedExceptionWrapper.wrap(e);
            }
            if (r == null) {
                return null;
            }
            return this.clientOptions.getDataConverter().fromPayloads(0, (Optional<Payloads>)r, resultClass, resultType);
        });
    }

    private <R> R mapToWorkflowFailureException(Exception failure, Class<R> returnType) {
        Throwable f = CheckedExceptionWrapper.unwrap(failure);
        if (f instanceof Error) {
            throw (Error)f;
        }
        failure = (Exception)f;
        if (failure instanceof WorkflowExecutionFailedException) {
            WorkflowExecutionFailedException executionFailed = (WorkflowExecutionFailedException)failure;
            RuntimeException cause = FailureConverter.failureToException(executionFailed.getFailure(), this.clientOptions.getDataConverter());
            throw new WorkflowFailedException(this.execution.get(), this.workflowType.orElse(null), executionFailed.getWorkflowTaskCompletedEventId(), executionFailed.getRetryState(), cause);
        }
        if (failure instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)((Object)failure);
            if (sre.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw new WorkflowNotFoundException(this.execution.get(), this.workflowType.orElse(null));
            }
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), failure);
        }
        if (failure instanceof CanceledFailure) {
            throw (CanceledFailure)failure;
        }
        if (failure instanceof WorkflowException) {
            throw (WorkflowException)failure;
        }
        throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), failure);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Object ... args) {
        return this.query(queryType, resultClass, resultClass, args);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Type resultType, Object ... args) {
        QueryWorkflowResponse result;
        this.checkStarted();
        WorkflowQuery.Builder query = WorkflowQuery.newBuilder().setQueryType(queryType);
        Optional<Payloads> input = this.clientOptions.getDataConverter().toPayloads(args);
        if (input.isPresent()) {
            query.setQueryArgs(input.get());
        }
        QueryWorkflowRequest request = QueryWorkflowRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setExecution(WorkflowExecution.newBuilder().setWorkflowId(this.execution.get().getWorkflowId()).setRunId(this.execution.get().getRunId())).setQuery(query).setQueryRejectCondition(this.clientOptions.getQueryRejectCondition()).build();
        try {
            result = this.genericClient.query(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw new WorkflowNotFoundException(this.execution.get(), this.workflowType.orElse(null));
            }
            if (StatusUtils.hasFailure(e, QueryFailedFailure.class)) {
                throw new WorkflowQueryException(this.execution.get(), this.workflowType.orElse(null), e);
            }
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
        catch (Exception e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
        if (!result.hasQueryRejected()) {
            Optional<Payloads> queryResult = result.hasQueryResult() ? Optional.of(result.getQueryResult()) : Optional.empty();
            return this.clientOptions.getDataConverter().fromPayloads(0, queryResult, resultClass, resultType);
        }
        throw new WorkflowQueryRejectedException(this.execution.get(), this.workflowType.orElse(null), this.clientOptions.getQueryRejectCondition(), result.getQueryRejected().getStatus(), null);
    }

    @Override
    public void cancel() {
        if (this.execution.get() == null || this.execution.get().getWorkflowId() == null) {
            throw new IllegalStateException("Not started");
        }
        RequestCancelWorkflowExecutionRequest.Builder request = RequestCancelWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(this.execution.get().getWorkflowId())).setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity());
        this.genericClient.requestCancel(request.build());
    }

    @Override
    public void terminate(String reason, Object ... details) {
        if (this.execution.get() == null || this.execution.get().getWorkflowId() == null) {
            throw new IllegalStateException("Not started");
        }
        TerminateWorkflowExecutionRequest.Builder request = TerminateWorkflowExecutionRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(this.execution.get().getWorkflowId())).setReason(reason);
        Optional<Payloads> payloads = this.clientOptions.getDataConverter().toPayloads(details);
        if (payloads.isPresent()) {
            request.setDetails(payloads.get());
        }
        this.genericClient.terminate(request.build());
    }

    @Override
    public Optional<WorkflowOptions> getOptions() {
        return this.options;
    }

    private void checkStarted() {
        if (this.execution.get() == null || this.execution.get().getWorkflowId() == null) {
            throw new IllegalStateException("Null workflowId. Was workflow started?");
        }
    }
}

