/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.common.GrpcRetryer;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.FailureWrapperException;
import io.temporal.internal.worker.ActivityPollTask;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.internal.worker.NoopSuspendableWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public final class ActivityWorker
implements SuspendableWorker {
    private static final String POLL_THREAD_NAME_PREFIX = "Activity Poller taskQueue=";
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private final ActivityTaskHandler handler;
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final double taskQueueActivitiesPerSecond;

    public ActivityWorker(WorkflowServiceStubs service, String namespace, String taskQueue, double taskQueueActivitiesPerSecond, SingleWorkerOptions options, ActivityTaskHandler handler) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.taskQueueActivitiesPerSecond = taskQueueActivitiesPerSecond;
        this.handler = handler;
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix("Activity Poller taskQueue=\"" + taskQueue + "\", namespace=\"" + namespace + "\"").build();
        }
        this.options = SingleWorkerOptions.newBuilder(options).setPollerOptions(pollerOptions).build();
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.poller = new Poller<ActivityTask>(this.options.getIdentity(), new ActivityPollTask(this.service, this.namespace, this.taskQueue, this.options, this.taskQueueActivitiesPerSecond), new PollTaskExecutor<ActivityTask>(this.namespace, this.taskQueue, this.options, new TaskHandlerImpl(this.handler)), this.options.getPollerOptions(), this.options.getMetricsScope());
            this.poller.start();
            this.options.getMetricsScope().counter("temporal_worker_start").inc(1L);
        }
    }

    @Override
    public boolean isStarted() {
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated();
    }

    @Override
    public void shutdown() {
        this.poller.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.poller.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<ActivityTask> {
        final ActivityTaskHandler handler;

        private TaskHandlerImpl(ActivityTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(ActivityTask task) throws Exception {
            PollActivityTaskQueueResponse r = task.getResponse();
            Scope metricsScope = ActivityWorker.this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"activity_type", (Object)r.getActivityType().getName(), (Object)"workflow_type", (Object)r.getWorkflowType().getName()));
            ActivityTaskHandler.Result response = null;
            try {
                metricsScope.timer("temporal_activity_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(r.getStartedTime(), r.getCurrentAttemptScheduledTime()));
                MDC.put((String)"ActivityId", (String)r.getActivityId());
                MDC.put((String)"ActivityType", (String)r.getActivityType().getName());
                MDC.put((String)"WorkflowId", (String)r.getWorkflowExecution().getWorkflowId());
                MDC.put((String)"RunId", (String)r.getWorkflowExecution().getRunId());
                this.propagateContext(r);
                Stopwatch sw = metricsScope.timer("temporal_activity_execution_latency").start();
                try {
                    response = this.handler.handle(task, metricsScope, false);
                }
                finally {
                    sw.stop();
                }
                this.sendReply(r, response, metricsScope);
                Duration duration = ProtobufTimeUtils.toM3DurationSinceNow(r.getCurrentAttemptScheduledTime());
                metricsScope.timer("temporal_activity_endtoend_latency").record(duration);
            }
            catch (FailureWrapperException e) {
                Failure failure = e.getFailure();
                if (failure.hasCanceledFailureInfo()) {
                    CanceledFailureInfo info = failure.getCanceledFailureInfo();
                    RespondActivityTaskCanceledRequest.Builder canceledRequest = RespondActivityTaskCanceledRequest.newBuilder().setIdentity(ActivityWorker.this.options.getIdentity()).setNamespace(ActivityWorker.this.namespace);
                    if (info.hasDetails()) {
                        canceledRequest.setDetails(info.getDetails());
                    }
                    response = new ActivityTaskHandler.Result(r.getActivityId(), null, null, canceledRequest.build(), null, false);
                    this.sendReply(r, response, metricsScope);
                }
            }
            finally {
                MDC.remove((String)"ActivityId");
                MDC.remove((String)"ActivityType");
                MDC.remove((String)"WorkflowId");
                MDC.remove((String)"RunId");
                if (response != null && !response.isManualCompletion()) {
                    task.getCompletionHandle().apply();
                }
            }
        }

        void propagateContext(PollActivityTaskQueueResponse response) {
            if (ActivityWorker.this.options.getContextPropagators() == null || ActivityWorker.this.options.getContextPropagators().isEmpty()) {
                return;
            }
            if (!response.hasHeader()) {
                return;
            }
            HashMap<String, Payload> headerData = new HashMap<String, Payload>();
            for (Map.Entry entry : response.getHeader().getFieldsMap().entrySet()) {
                headerData.put((String)entry.getKey(), (Payload)entry.getValue());
            }
            for (ContextPropagator propagator : ActivityWorker.this.options.getContextPropagators()) {
                propagator.setCurrentContext(propagator.deserializeContext(headerData));
            }
        }

        @Override
        public Throwable wrapFailure(ActivityTask t, Throwable failure) {
            PollActivityTaskQueueResponse response = t.getResponse();
            WorkflowExecution execution = response.getWorkflowExecution();
            return new RuntimeException("Failure processing activity response. WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + ", ActivityType=" + response.getActivityType().getName() + ", ActivityId=" + response.getActivityId(), failure);
        }

        private void sendReply(PollActivityTaskQueueResponse task, ActivityTaskHandler.Result response, Scope metricsScope) {
            RpcRetryOptions ro = response.getRequestRetryOptions();
            RespondActivityTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                ro = RpcRetryOptions.newBuilder().buildWithDefaultsFrom(ro);
                RespondActivityTaskCompletedRequest request = taskCompleted.toBuilder().setTaskToken(task.getTaskToken()).setIdentity(ActivityWorker.this.options.getIdentity()).setNamespace(ActivityWorker.this.namespace).build();
                GrpcRetryer.retry(ro, () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)ActivityWorker.this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).respondActivityTaskCompleted(request));
            } else {
                ActivityTaskHandler.Result.TaskFailedResult taskFailed = response.getTaskFailed();
                if (taskFailed != null) {
                    RespondActivityTaskFailedRequest request = taskFailed.getTaskFailedRequest().toBuilder().setTaskToken(task.getTaskToken()).setIdentity(ActivityWorker.this.options.getIdentity()).setNamespace(ActivityWorker.this.namespace).build();
                    ro = RpcRetryOptions.newBuilder().buildWithDefaultsFrom(ro);
                    GrpcRetryer.retry(ro, () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)ActivityWorker.this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).respondActivityTaskFailed(request));
                } else {
                    RespondActivityTaskCanceledRequest taskCanceled = response.getTaskCanceled();
                    if (taskCanceled != null) {
                        RespondActivityTaskCanceledRequest request = taskCanceled.toBuilder().setTaskToken(task.getTaskToken()).setIdentity(ActivityWorker.this.options.getIdentity()).setNamespace(ActivityWorker.this.namespace).build();
                        ro = RpcRetryOptions.newBuilder().buildWithDefaultsFrom(ro);
                        GrpcRetryer.retry(ro, () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)ActivityWorker.this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).respondActivityTaskCanceled(request));
                    }
                }
            }
        }
    }
}

