/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.common.RetryOptions;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.internal.worker.LocalActivityPollTask;
import io.temporal.internal.worker.NoopSuspendableWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalActivityWorker
implements SuspendableWorker {
    private static final String POLL_THREAD_NAME_PREFIX = "Local Activity Poller taskQueue=";
    private static final Logger log = LoggerFactory.getLogger(LocalActivityWorker.class);
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private final ActivityTaskHandler handler;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final LocalActivityPollTask laPollTask;

    public LocalActivityWorker(String namespace, String taskQueue, SingleWorkerOptions options, ActivityTaskHandler handler) {
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.handler = handler;
        this.laPollTask = new LocalActivityPollTask();
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix("Local Activity Poller taskQueue=\"" + taskQueue + "\", namespace=\"" + namespace + "\"").build();
        }
        this.options = SingleWorkerOptions.newBuilder(options).setPollerOptions(pollerOptions).build();
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.poller = new Poller<Task>(this.options.getIdentity(), this.laPollTask, new PollTaskExecutor<Task>(this.namespace, this.taskQueue, this.options, new TaskHandlerImpl(this.handler)), this.options.getPollerOptions(), this.options.getMetricsScope());
            this.poller.start();
            this.options.getMetricsScope().counter("temporal_worker_start").inc(1L);
        }
    }

    public boolean isAnyTypeSupported() {
        return this.handler.isAnyTypeSupported();
    }

    @Override
    public boolean isStarted() {
        if (this.poller == null) {
            return false;
        }
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        if (this.poller == null) {
            return true;
        }
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.poller == null) {
            return true;
        }
        return this.poller.isTerminated();
    }

    @Override
    public void shutdown() {
        if (this.poller == null) {
            return;
        }
        this.poller.shutdown();
    }

    @Override
    public void shutdownNow() {
        if (this.poller == null) {
            return;
        }
        this.poller.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        if (this.poller == null) {
            return;
        }
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        if (this.poller == null) {
            return;
        }
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        if (this.poller == null) {
            return true;
        }
        return this.poller.isSuspended();
    }

    public BiFunction<Task, Duration, Boolean> getLocalActivityTaskPoller() {
        return this.laPollTask;
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<Task> {
        final ActivityTaskHandler handler;

        private TaskHandlerImpl(ActivityTaskHandler handler) {
            this.handler = handler;
        }

        @Override
        public void handle(Task task) throws Exception {
            task.taskStartTime = System.currentTimeMillis();
            ActivityTaskHandler.Result result = this.handleLocalActivity(task);
            task.eventConsumer.apply(result);
        }

        @Override
        public Throwable wrapFailure(Task task, Throwable failure) {
            return new RuntimeException("Failure processing local activity task.", failure);
        }

        private ActivityTaskHandler.Result handleLocalActivity(Task task) throws InterruptedException {
            Optional<Duration> expiration;
            ExecuteLocalActivityParameters params = task.params;
            PollActivityTaskQueueResponse.Builder activityTask = params.getActivityTask();
            ImmutableMap activityTypeTag = new ImmutableMap.Builder(1).put((Object)"activity_type", (Object)activityTask.getActivityType().getName()).put((Object)"workflow_type", (Object)activityTask.getWorkflowType().getName()).build();
            Scope metricsScope = LocalActivityWorker.this.options.getMetricsScope().tagged((Map)activityTypeTag);
            metricsScope.counter("temporal_local_activity_total").inc(1L);
            Stopwatch sw = metricsScope.timer("temporal_local_activity_execution_latency").start();
            ActivityTaskHandler.Result result = this.handler.handle(new ActivityTask(activityTask.build(), () -> {}), metricsScope, true);
            sw.stop();
            int attempt = activityTask.getAttempt();
            result.setAttempt(attempt);
            if (result.getTaskCompleted() != null || result.getTaskCanceled() != null || !activityTask.hasRetryPolicy()) {
                return result;
            }
            RetryPolicy retryPolicy = activityTask.getRetryPolicy();
            Object[] doNotRetry = new String[retryPolicy.getNonRetryableErrorTypesCount()];
            retryPolicy.getNonRetryableErrorTypesList().toArray(doNotRetry);
            RetryOptions.Builder roBuilder = RetryOptions.newBuilder();
            if (retryPolicy.getMaximumInterval().getNanos() > 0) {
                roBuilder.setMaximumInterval(ProtobufTimeUtils.toJavaDuration(retryPolicy.getMaximumInterval()));
            }
            if (retryPolicy.getInitialInterval().getNanos() > 0) {
                roBuilder.setInitialInterval(ProtobufTimeUtils.toJavaDuration(retryPolicy.getInitialInterval()));
            }
            if (retryPolicy.getBackoffCoefficient() >= 1.0) {
                roBuilder.setBackoffCoefficient(retryPolicy.getBackoffCoefficient());
            }
            if (retryPolicy.getMaximumAttempts() > 0) {
                roBuilder.setMaximumAttempts(retryPolicy.getMaximumAttempts());
            }
            roBuilder.setDoNotRetry((String[])doNotRetry).build();
            RetryOptions retryOptions = roBuilder.validateBuildWithDefaults();
            long sleepMillis = retryOptions.calculateSleepTime(attempt);
            long elapsedTask = System.currentTimeMillis() - task.taskStartTime;
            long sinceScheduled = System.currentTimeMillis() - Timestamps.toMillis((Timestamp)activityTask.getScheduledTime());
            long elapsedTotal = elapsedTask + sinceScheduled;
            Duration timeout = ProtobufTimeUtils.toJavaDuration(activityTask.getScheduleToCloseTimeout());
            Optional<Duration> optional = expiration = timeout.compareTo(Duration.ZERO) > 0 ? Optional.of(timeout) : Optional.empty();
            if (retryOptions.shouldRethrow(result.getTaskFailed().getFailure(), expiration, attempt, elapsedTotal, sleepMillis)) {
                return result;
            }
            result.setBackoff(Duration.ofMillis(sleepMillis));
            if (elapsedTask + sleepMillis < task.params.getLocalRetryThreshold().toMillis()) {
                Thread.sleep(sleepMillis);
                activityTask.setAttempt(attempt + 1);
                return this.handleLocalActivity(task);
            }
            return result;
        }
    }

    public static class Task {
        private final ExecuteLocalActivityParameters params;
        private final Functions.Proc1<ActivityTaskHandler.Result> eventConsumer;
        long taskStartTime;

        public Task(ExecuteLocalActivityParameters params, Functions.Proc1<ActivityTaskHandler.Result> eventConsumer) {
            this.params = params;
            this.eventConsumer = eventConsumer;
        }

        public String getActivityId() {
            return this.params.getActivityTask().getActivityId();
        }
    }
}

