/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.client.WorkflowException;

public final class WorkflowFailedException
extends WorkflowException {
    private final RetryState retryState;
    private final long workflowTaskCompletedEventId;

    public WorkflowFailedException(WorkflowExecution workflowExecution, String workflowType, long workflowTaskCompletedEventId, RetryState retryState, Throwable cause) {
        super(WorkflowFailedException.getMessage(workflowExecution, workflowType, workflowTaskCompletedEventId, retryState), workflowExecution, workflowType, cause);
        this.retryState = retryState;
        this.workflowTaskCompletedEventId = workflowTaskCompletedEventId;
    }

    public RetryState getRetryState() {
        return this.retryState;
    }

    public long getWorkflowTaskCompletedEventId() {
        return this.workflowTaskCompletedEventId;
    }

    public static String getMessage(WorkflowExecution workflowExecution, String workflowType, long workflowTaskCompletedEventId, RetryState retryState) {
        return "workflowId='" + workflowExecution.getWorkflowId() + "', runId='" + workflowExecution.getRunId() + (workflowType == null ? "'" : "', workflowType='" + workflowType + '\'') + ", retryState=" + retryState + ", workflowTaskCompletedEventId=" + workflowTaskCompletedEventId;
    }
}

