/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.failure;

import com.google.common.base.Strings;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.converter.Values;
import io.temporal.failure.TemporalFailure;
import java.util.Objects;

public final class ApplicationFailure
extends TemporalFailure {
    private final String type;
    private final Values details;
    private boolean nonRetryable;

    public static ApplicationFailure newFailure(String message, String type, Object ... details) {
        return new ApplicationFailure(message, type, false, new EncodedValues(details), null);
    }

    public static ApplicationFailure newNonRetryableFailure(String message, String type, Object ... details) {
        return new ApplicationFailure(message, type, true, new EncodedValues(details), null);
    }

    static ApplicationFailure newFromValues(String message, String type, boolean nonRetryable, Values details, Throwable cause) {
        return new ApplicationFailure(message, type, nonRetryable, details, cause);
    }

    ApplicationFailure(String message, String type, boolean nonRetryable, Values details, Throwable cause) {
        super(ApplicationFailure.getMessage(message, Objects.requireNonNull(type), nonRetryable), message, cause);
        this.type = type;
        this.details = details;
        this.nonRetryable = nonRetryable;
    }

    public String getType() {
        return this.type;
    }

    public Values getDetails() {
        return this.details;
    }

    public void setNonRetryable(boolean nonRetryable) {
        this.nonRetryable = nonRetryable;
    }

    public boolean isNonRetryable() {
        return this.nonRetryable;
    }

    @Override
    public void setDataConverter(DataConverter converter) {
        ((EncodedValues)this.details).setDataConverter(converter);
    }

    private static String getMessage(String message, String type, boolean nonRetryable) {
        return (Strings.isNullOrEmpty((String)message) ? "" : "message='" + message + "', ") + "type='" + type + '\'' + ", nonRetryable=" + nonRetryable;
    }
}

