/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.activity.ActivityCancellationType;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RequestCancelActivityTaskCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.ActivityFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.ActivityTaskCanceledEventAttributes;
import io.temporal.api.history.v1.ActivityTaskCompletedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskFailedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskTimedOutEventAttributes;
import io.temporal.internal.replay.ExecuteActivityParameters;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;
import java.util.Optional;

final class ActivityStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, ActivityStateMachine> {
    private String activityId;
    private ActivityType activityType;
    private ActivityCancellationType cancellationType;
    public static final StateMachineDefinition<State, ExplicitEvent, ActivityStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("Activity", State.CREATED, State.COMPLETED, State.FAILED, State.TIMED_OUT, State.CANCELED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.SCHEDULE_COMMAND_CREATED, ActivityStateMachine::createScheduleActivityTaskCommand).add(State.SCHEDULE_COMMAND_CREATED, CommandType.COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK, State.SCHEDULE_COMMAND_CREATED).add(State.SCHEDULE_COMMAND_CREATED, EventType.EVENT_TYPE_ACTIVITY_TASK_SCHEDULED, State.SCHEDULED_EVENT_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.SCHEDULE_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCELED, ActivityStateMachine::cancelCommandNotifyCanceled).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_STARTED, State.STARTED, ActivityStateMachine::setStartedCommandEventId).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.SCHEDULED_EVENT_RECORDED, ExplicitEvent.CANCEL, State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, ActivityStateMachine::createRequestCancelActivityTaskCommand).add(State.STARTED, EventType.EVENT_TYPE_ACTIVITY_TASK_COMPLETED, State.COMPLETED, ActivityStateMachine::notifyCompleted).add(State.STARTED, EventType.EVENT_TYPE_ACTIVITY_TASK_FAILED, State.FAILED, ActivityStateMachine::notifyFailed).add(State.STARTED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.STARTED, ExplicitEvent.CANCEL, State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED, ActivityStateMachine::createRequestCancelActivityTaskCommand).add(State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, CommandType.COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK, State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, ActivityStateMachine::notifyCanceledIfTryCancel).add(State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED, State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED).add(State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCELED, State.CANCELED, ActivityStateMachine::notifyCanceled).add(State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_STARTED, State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED).add(State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED, CommandType.COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK, State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED).add(State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED, State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, ActivityStateMachine::notifyCanceledIfTryCancel).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_FAILED, State.FAILED, ActivityStateMachine::notifyFailed).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_COMPLETED, State.COMPLETED, ActivityStateMachine::notifyCompleted).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCELED, State.CANCELED, ActivityStateMachine::notifyCancellationFromEvent);
    private ExecuteActivityParameters parameters;
    private final Functions.Proc2<Optional<Payloads>, Failure> completionCallback;
    private long startedCommandEventId;

    public static ActivityStateMachine newInstance(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new ActivityStateMachine(parameters, completionCallback, commandSink, stateMachineSink);
    }

    private ActivityStateMachine(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.parameters = parameters;
        ScheduleActivityTaskCommandAttributes.Builder scheduleAttr = parameters.getAttributes();
        this.activityId = scheduleAttr.getActivityId();
        this.activityType = scheduleAttr.getActivityType();
        this.cancellationType = parameters.getCancellationType();
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    public void createScheduleActivityTaskCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK).setScheduleActivityTaskCommandAttributes(this.parameters.getAttributes()).build());
    }

    public void cancel() {
        if (this.cancellationType == ActivityCancellationType.ABANDON) {
            this.notifyCanceled();
        } else if (!this.isFinalState()) {
            this.explicitEvent(ExplicitEvent.CANCEL);
        }
    }

    private void setStartedCommandEventId() {
        this.startedCommandEventId = this.currentEvent.getEventId();
    }

    private void cancelCommandNotifyCanceled() {
        this.cancelCommand();
        if (this.cancellationType != ActivityCancellationType.ABANDON) {
            this.notifyCanceled();
        }
    }

    private void notifyCanceledIfTryCancel() {
        if (this.cancellationType == ActivityCancellationType.TRY_CANCEL) {
            this.notifyCanceled();
        }
    }

    private void notifyCanceled() {
        Failure canceledFailure = Failure.newBuilder().setSource("JavaSDK").setCanceledFailureInfo(CanceledFailureInfo.getDefaultInstance()).build();
        ActivityFailureInfo activityFailureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setIdentity("workflow").setScheduledEventId(this.getInitialCommandEventId()).setStartedEventId(this.startedCommandEventId).build();
        Failure failure = Failure.newBuilder().setActivityFailureInfo(activityFailureInfo).setCause(canceledFailure).setMessage("Activity canceled").build();
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyCompleted() {
        ActivityTaskCompletedEventAttributes completedAttr = this.currentEvent.getActivityTaskCompletedEventAttributes();
        Optional result = completedAttr.hasResult() ? Optional.of(completedAttr.getResult()) : Optional.empty();
        this.completionCallback.apply(result, null);
    }

    private void notifyFailed() {
        ActivityTaskFailedEventAttributes failed = this.currentEvent.getActivityTaskFailedEventAttributes();
        ActivityFailureInfo failureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setIdentity(failed.getIdentity()).setRetryState(failed.getRetryState()).setScheduledEventId(failed.getScheduledEventId()).setStartedEventId(failed.getStartedEventId()).build();
        Failure failure = Failure.newBuilder().setActivityFailureInfo(failureInfo).setCause(failed.getFailure()).setMessage("Activity task failed").build();
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyTimedOut() {
        ActivityTaskTimedOutEventAttributes timedOut = this.currentEvent.getActivityTaskTimedOutEventAttributes();
        ActivityFailureInfo failureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setRetryState(timedOut.getRetryState()).setScheduledEventId(timedOut.getScheduledEventId()).setStartedEventId(timedOut.getStartedEventId()).build();
        Failure failure = Failure.newBuilder().setActivityFailureInfo(failureInfo).setCause(timedOut.getFailure()).setMessage("Activity task timedOut").build();
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyCancellationFromEvent() {
        if (this.cancellationType == ActivityCancellationType.WAIT_CANCELLATION_COMPLETED) {
            ActivityTaskCanceledEventAttributes canceledAttr = this.currentEvent.getActivityTaskCanceledEventAttributes();
            Failure canceledFailure = Failure.newBuilder().setSource("JavaSDK").setCanceledFailureInfo(CanceledFailureInfo.newBuilder().setDetails(canceledAttr.getDetails())).build();
            ActivityFailureInfo failureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setScheduledEventId(canceledAttr.getScheduledEventId()).setStartedEventId(canceledAttr.getStartedEventId()).build();
            Failure failure = Failure.newBuilder().setActivityFailureInfo(failureInfo).setCause(canceledFailure).setMessage("Activity canceled").build();
            this.completionCallback.apply(Optional.empty(), failure);
        }
    }

    private void createRequestCancelActivityTaskCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK).setRequestCancelActivityTaskCommandAttributes(RequestCancelActivityTaskCommandAttributes.newBuilder().setScheduledEventId(this.getInitialCommandEventId())).build());
        this.parameters = null;
    }

    static enum State {
        CREATED,
        SCHEDULE_COMMAND_CREATED,
        SCHEDULED_EVENT_RECORDED,
        STARTED,
        COMPLETED,
        FAILED,
        TIMED_OUT,
        CANCELED,
        SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED,
        SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED,
        STARTED_ACTIVITY_CANCEL_COMMAND_CREATED,
        STARTED_ACTIVITY_CANCEL_EVENT_RECORDED;

    }

    static enum ExplicitEvent {
        SCHEDULE,
        CANCEL;

    }
}

