/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class AllOfPromise
implements Promise<Void> {
    private final CompletablePromise<Void> impl = Workflow.newPromise();
    private int notReadyCount;

    AllOfPromise(Promise<?>[] promises) {
        for (Promise<?> f : promises) {
            this.addPromise(f);
        }
        if (this.notReadyCount == 0) {
            this.impl.complete(null);
        }
    }

    public <V> AllOfPromise(Iterable<Promise<V>> promises) {
        for (Promise<V> f : promises) {
            this.addPromise(f);
        }
        if (this.notReadyCount == 0) {
            this.impl.complete(null);
        }
    }

    private void addPromise(Promise<?> f) {
        if (!f.isCompleted()) {
            ++this.notReadyCount;
            f.handle((? super V r, RuntimeException e) -> {
                if (this.notReadyCount == 0) {
                    throw new Error("Unexpected 0 count");
                }
                if (this.impl.isCompleted()) {
                    return null;
                }
                if (e != null) {
                    this.impl.completeExceptionally((RuntimeException)e);
                }
                if (--this.notReadyCount == 0) {
                    this.impl.complete(null);
                }
                return null;
            });
        }
    }

    @Override
    public boolean isCompleted() {
        return this.impl.isCompleted();
    }

    @Override
    public Void get() {
        return (Void)this.impl.get();
    }

    @Override
    public Void cancellableGet() {
        return (Void)this.impl.cancellableGet();
    }

    @Override
    public Void cancellableGet(long timeout, TimeUnit unit) throws TimeoutException {
        return (Void)this.impl.cancellableGet(timeout, unit);
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws TimeoutException {
        return (Void)this.impl.get(timeout, unit);
    }

    @Override
    public RuntimeException getFailure() {
        return this.impl.getFailure();
    }

    @Override
    public <U> Promise<U> thenApply(Functions.Func1<? super Void, ? extends U> fn) {
        return this.impl.thenApply(fn);
    }

    @Override
    public <U> Promise<U> handle(Functions.Func2<? super Void, RuntimeException, ? extends U> fn) {
        return this.impl.handle(fn);
    }

    @Override
    public <U> Promise<U> thenCompose(Functions.Func1<? super Void, ? extends Promise<U>> fn) {
        return this.impl.thenCompose(fn);
    }

    @Override
    public Promise<Void> exceptionally(Functions.Func1<Throwable, ? extends Void> fn) {
        return this.impl.exceptionally(fn);
    }
}

