/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.ContinueAsNewOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;

class ContinueAsNewWorkflowInvocationHandler
implements InvocationHandler {
    private final ContinueAsNewOptions options;
    private final WorkflowOutboundCallsInterceptor outboundCallsInterceptor;
    private final POJOWorkflowInterfaceMetadata workflowMetadata;

    ContinueAsNewWorkflowInvocationHandler(Class<?> interfaceClass, ContinueAsNewOptions options, WorkflowOutboundCallsInterceptor outboundCallsInterceptor) {
        this.workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(interfaceClass);
        if (!this.workflowMetadata.getWorkflowMethod().isPresent()) {
            throw new IllegalArgumentException("Missing method annotated with @WorkflowMethod: " + interfaceClass.getName());
        }
        this.options = options;
        this.outboundCallsInterceptor = outboundCallsInterceptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String workflowType = this.workflowMetadata.getMethodMetadata(method).getName();
        WorkflowInternal.continueAsNew(Optional.of(workflowType), Optional.ofNullable(this.options), args, this.outboundCallsInterceptor);
        return InternalUtils.getValueOrDefault(null, method.getReturnType());
    }
}

