/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.protobuf.MessageOrBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.temporal.internal.common.WorkflowExecutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);

    LoggingInterceptor() {
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall myCall = new ServerCall<ReqT, RespT>(){

            public void request(int numMessages) {
                call.request(numMessages);
            }

            public void sendHeaders(Metadata headers) {
                call.sendHeaders(headers);
            }

            public void sendMessage(RespT message) {
                log.trace("Reply to " + call.getMethodDescriptor().getFullMethodName() + " with output:\n" + WorkflowExecutionUtils.prettyPrintObject((MessageOrBuilder)message));
                call.sendMessage(message);
            }

            public void close(Status status, Metadata trailers) {
                call.close(status, trailers);
            }

            public boolean isCancelled() {
                return call.isCancelled();
            }

            public MethodDescriptor<ReqT, RespT> getMethodDescriptor() {
                return call.getMethodDescriptor();
            }
        };
        final ServerCall.Listener listener = next.startCall(myCall, headers);
        return new ServerCall.Listener<ReqT>(){

            public void onMessage(ReqT message) {
                log.trace("Received request " + call.getMethodDescriptor().getFullMethodName() + " with input:\n" + WorkflowExecutionUtils.prettyPrintObject((MessageOrBuilder)message));
                listener.onMessage(message);
            }

            public void onComplete() {
                listener.onComplete();
            }

            public void onHalfClose() {
                listener.onHalfClose();
            }

            public void onCancel() {
                listener.onCancel();
            }

            public void onReady() {
                listener.onReady();
            }
        };
    }
}

