/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.BatchRequest;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.internal.client.RootWorkflowClientInvoker;
import io.temporal.internal.external.GenericWorkflowClientExternalImpl;
import io.temporal.internal.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.external.ManualActivityCompletionClientFactoryImpl;
import io.temporal.internal.sync.ActivityCompletionClientImpl;
import io.temporal.internal.sync.SignalWithStartBatchRequest;
import io.temporal.internal.sync.StubMarker;
import io.temporal.internal.sync.WorkflowInvocationHandler;
import io.temporal.internal.sync.WorkflowStubImpl;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import io.temporal.workflow.QueryMethod;
import io.temporal.workflow.SignalMethod;
import io.temporal.workflow.WorkflowMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class WorkflowClientInternal
implements WorkflowClient {
    private final GenericWorkflowClientExternalImpl genericClient;
    private final WorkflowClientOptions options;
    private final ManualActivityCompletionClientFactory manualActivityCompletionClientFactory;
    private final DataConverter dataConverter;
    private final WorkflowClientInterceptor[] interceptors;
    private final WorkflowClientCallsInterceptor workflowClientCallsInvoker;
    private final WorkflowServiceStubs workflowServiceStubs;
    private final Scope metricsScope;

    public static WorkflowClient newInstance(WorkflowServiceStubs service, WorkflowClientOptions options) {
        return new WorkflowClientInternal(service, options);
    }

    private WorkflowClientInternal(WorkflowServiceStubs workflowServiceStubs, WorkflowClientOptions options) {
        this.options = options = WorkflowClientOptions.newBuilder(options).validateAndBuildWithDefaults();
        this.workflowServiceStubs = workflowServiceStubs;
        String namespace = options.getNamespace() == null ? "default" : options.getNamespace();
        this.metricsScope = workflowServiceStubs.getOptions().getMetricsScope().tagged(MetricsTag.defaultTags((String)namespace));
        this.genericClient = new GenericWorkflowClientExternalImpl(workflowServiceStubs, options.getNamespace(), options.getIdentity(), this.metricsScope);
        this.dataConverter = options.getDataConverter();
        this.interceptors = options.getInterceptors();
        this.workflowClientCallsInvoker = this.initializeClientInvoker();
        this.manualActivityCompletionClientFactory = new ManualActivityCompletionClientFactoryImpl(workflowServiceStubs, options.getNamespace(), this.dataConverter, this.metricsScope);
    }

    private WorkflowClientCallsInterceptor initializeClientInvoker() {
        WorkflowClientCallsInterceptor workflowClientInvoker = new RootWorkflowClientInvoker(this.genericClient, this.options, this.metricsScope);
        for (WorkflowClientInterceptor clientInterceptor : this.interceptors) {
            workflowClientInvoker = clientInterceptor.workflowClientCallsInterceptor(workflowClientInvoker);
        }
        return workflowClientInvoker;
    }

    @Override
    public WorkflowServiceStubs getWorkflowServiceStubs() {
        return this.workflowServiceStubs;
    }

    @Override
    public WorkflowClientOptions getOptions() {
        return this.options;
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, WorkflowOptions options) {
        WorkflowClientInternal.checkAnnotation(workflowInterface, WorkflowMethod.class);
        WorkflowInvocationHandler invocationHandler = new WorkflowInvocationHandler(workflowInterface, this.getOptions(), this.workflowClientCallsInvoker, options);
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class}, (InvocationHandler)invocationHandler);
    }

    @SafeVarargs
    private static <T> void checkAnnotation(Class<T> workflowInterface, Class<? extends Annotation> ... annotationClasses) {
        TypeToken.TypeSet interfaces = TypeToken.of(workflowInterface).getTypes().interfaces();
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException("Workflow must implement at least one interface");
        }
        for (TypeToken i : interfaces) {
            for (Method method : i.getRawType().getMethods()) {
                for (Class<? extends Annotation> annotationClass : annotationClasses) {
                    Annotation workflowMethod = method.getAnnotation(annotationClass);
                    if (workflowMethod == null) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Workflow interface " + workflowInterface.getName() + " doesn't have method annotated with any of " + Arrays.toString(annotationClasses));
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, String workflowId) {
        return this.newWorkflowStub(workflowInterface, workflowId, Optional.empty());
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, String workflowId, Optional<String> runId) {
        WorkflowClientInternal.checkAnnotation(workflowInterface, WorkflowMethod.class, QueryMethod.class, SignalMethod.class);
        if (Strings.isNullOrEmpty((String)workflowId)) {
            throw new IllegalArgumentException("workflowId is null or empty");
        }
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
        WorkflowInvocationHandler invocationHandler = new WorkflowInvocationHandler(workflowInterface, this.getOptions(), this.workflowClientCallsInvoker, execution);
        Object result = Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class}, (InvocationHandler)invocationHandler);
        return (T)result;
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowType, WorkflowOptions workflowOptions) {
        WorkflowStub result = new WorkflowStubImpl(this.options, this.workflowClientCallsInvoker, workflowType, workflowOptions);
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newUntypedWorkflowStub(workflowType, workflowOptions, result);
        }
        return result;
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowId, Optional<String> runId, Optional<String> workflowType) {
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
        return this.newUntypedWorkflowStub(execution, workflowType);
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(WorkflowExecution execution, Optional<String> workflowType) {
        return new WorkflowStubImpl(this.options, this.workflowClientCallsInvoker, workflowType, execution);
    }

    @Override
    public ActivityCompletionClient newActivityCompletionClient() {
        ActivityCompletionClient result = new ActivityCompletionClientImpl(this.manualActivityCompletionClientFactory, () -> {});
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newActivityCompletionClient(result);
        }
        return result;
    }

    @Override
    public BatchRequest newSignalWithStartRequest() {
        return new SignalWithStartBatchRequest();
    }

    @Override
    public WorkflowExecution signalWithStart(BatchRequest signalWithStartBatch) {
        return ((SignalWithStartBatchRequest)signalWithStartBatch).invoke();
    }

    public static WorkflowExecution start(Functions.Proc workflow) {
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.START);
        try {
            workflow.apply();
            WorkflowExecution workflowExecution = WorkflowInvocationHandler.getAsyncInvocationResult(WorkflowExecution.class);
            return workflowExecution;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    public static <A1> WorkflowExecution start(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1));
    }

    public static <A1, A2> WorkflowExecution start(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3> WorkflowExecution start(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> WorkflowExecution start(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> WorkflowExecution start(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> WorkflowExecution start(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> WorkflowExecution start(Functions.Func<R> workflow) {
        return WorkflowClientInternal.start(() -> workflow.apply());
    }

    public static <A1, R> WorkflowExecution start(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1));
    }

    public static <A1, A2, R> WorkflowExecution start(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> WorkflowExecution start(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> WorkflowExecution start(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> WorkflowExecution start(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> WorkflowExecution start(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static CompletableFuture<Void> execute(Functions.Proc workflow) {
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.EXECUTE);
        try {
            workflow.apply();
            CompletableFuture completableFuture = WorkflowInvocationHandler.getAsyncInvocationResult(CompletableFuture.class);
            return completableFuture;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    public static <A1> CompletableFuture<Void> execute(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1));
    }

    public static <A1, A2> CompletableFuture<Void> execute(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3> CompletableFuture<Void> execute(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> CompletableFuture<Void> execute(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> CompletableFuture<Void> execute(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> CompletableFuture<Void> execute(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> CompletableFuture<R> execute(Functions.Func<R> workflow) {
        return WorkflowClientInternal.execute(() -> workflow.apply());
    }

    public static <A1, R> CompletableFuture<R> execute(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1));
    }

    public static <A1, A2, R> CompletableFuture<R> execute(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> CompletableFuture<R> execute(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> CompletableFuture<R> execute(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> CompletableFuture<R> execute(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> CompletableFuture<R> execute(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }
}

