/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.DoubleValue;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.taskqueue.v1.TaskQueueMetadata;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityPollTask
implements Poller.PollTask<ActivityTask> {
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private static final Logger log = LoggerFactory.getLogger(ActivityPollTask.class);
    private final double taskQueueActivitiesPerSecond;
    private final Scope metricsScope;
    private final Semaphore pollSemaphore;

    public ActivityPollTask(WorkflowServiceStubs service, String namespace, String taskQueue, SingleWorkerOptions options, double taskQueueActivitiesPerSecond) {
        this.service = service;
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.options = options;
        this.metricsScope = options.getMetricsScope();
        this.taskQueueActivitiesPerSecond = taskQueueActivitiesPerSecond;
        this.pollSemaphore = new Semaphore(options.getTaskExecutorThreadPoolSize());
    }

    @Override
    public ActivityTask poll() {
        PollActivityTaskQueueResponse response;
        PollActivityTaskQueueRequest.Builder pollRequest = PollActivityTaskQueueRequest.newBuilder().setNamespace(this.namespace).setIdentity(this.options.getIdentity()).setTaskQueue(TaskQueue.newBuilder().setName(this.taskQueue));
        if (this.taskQueueActivitiesPerSecond > 0.0) {
            pollRequest.setTaskQueueMetadata(TaskQueueMetadata.newBuilder().setMaxTasksPerSecond(DoubleValue.newBuilder().setValue(this.taskQueueActivitiesPerSecond).build()).build());
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + pollRequest);
        }
        boolean isSuccessful = false;
        try {
            this.pollSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            response = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollActivityTaskQueue(pollRequest.build());
            if (response == null || response.getTaskToken().isEmpty()) {
                this.metricsScope.counter("temporal_activity_poll_no_task").inc(1L);
                ActivityTask e = null;
                return e;
            }
            this.metricsScope.timer("temporal_activity_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(response.getStartedTime(), response.getCurrentAttemptScheduledTime()));
            isSuccessful = true;
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.UNAVAILABLE && e.getMessage().startsWith("UNAVAILABLE: Channel shutdown")) {
                ActivityTask activityTask = null;
                return activityTask;
            }
            throw e;
        }
        finally {
            if (!isSuccessful) {
                this.pollSemaphore.release();
            }
        }
        return new ActivityTask(response, this.pollSemaphore::release);
    }
}

