/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.WorkflowWorker;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowPollTask
implements Poller.PollTask<PollWorkflowTaskQueueResponse> {
    private final Scope metricsScope;
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final String identity;
    private static final Logger log = LoggerFactory.getLogger(WorkflowWorker.class);
    private final String binaryChecksum;

    WorkflowPollTask(WorkflowServiceStubs service, String namespace, String taskQueue, Scope metricsScope, String identity, String binaryChecksum) {
        this.identity = Objects.requireNonNull(identity);
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.metricsScope = Objects.requireNonNull(metricsScope);
        this.binaryChecksum = binaryChecksum;
    }

    @Override
    public PollWorkflowTaskQueueResponse poll() {
        PollWorkflowTaskQueueResponse result;
        PollWorkflowTaskQueueRequest pollRequest = PollWorkflowTaskQueueRequest.newBuilder().setNamespace(this.namespace).setBinaryChecksum(this.binaryChecksum).setIdentity(this.identity).setTaskQueue(TaskQueue.newBuilder().setName(this.taskQueue).build()).build();
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + pollRequest);
        }
        try {
            result = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollWorkflowTaskQueue(pollRequest);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.UNAVAILABLE && e.getMessage().startsWith("UNAVAILABLE: Channel shutdown")) {
                return null;
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request returned workflow task: workflowType=" + result.getWorkflowType() + ", workflowExecution=" + result.getWorkflowExecution() + ", startedEventId=" + result.getStartedEventId() + ", previousStartedEventId=" + result.getPreviousStartedEventId() + (result.getQuery() != null ? ", queryType=" + result.getQuery().getQueryType() : ""));
        }
        if (result == null || result.getTaskToken().isEmpty()) {
            this.metricsScope.counter("temporal_workflow_task_queue_poll_empty").inc(1L);
            return null;
        }
        this.metricsScope.counter("temporal_workflow_task_queue_poll_succeed").inc(1L);
        this.metricsScope.timer("temporal_workflow_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(result.getStartedTime(), result.getScheduledTime()));
        return result;
    }
}

