/*
 *  Copyright (C) 2020 Temporal Technologies, Inc. All Rights Reserved.
 *
 *  Copyright 2012-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Modifications copyright (C) 2017 Uber Technologies, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not
 *  use this file except in compliance with the License. A copy of the License is
 *  located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 *  or in the "license" file accompanying this file. This file is distributed on
 *  an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *  express or implied. See the License for the specific language governing
 *  permissions and limitations under the License.
 */

package io.temporal.common.interceptors;

import io.temporal.common.Experimental;

/**
 * Intercepts workflow and activity executions.
 *
 * <p>TODO(maxim): JavaDoc with sample
 */
@Experimental
public interface WorkerInterceptor {
  /**
   * Called when workflow class is instantiated. May create a {@link
   * WorkflowInboundCallsInterceptor} instance. The instance must forward all the calls to {@code
   * next} {@link WorkflowInboundCallsInterceptor}, but it may change the input parameters.
   *
   * @param next an existing interceptor instance to be proxied by the interceptor created inside
   *     this method
   * @return an interceptor that passes all the calls to {@code next}
   */
  WorkflowInboundCallsInterceptor interceptWorkflow(WorkflowInboundCallsInterceptor next);

  ActivityInboundCallsInterceptor interceptActivity(ActivityInboundCallsInterceptor next);
}
