/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.DefaultDataConverter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;

public interface DataConverter {
    public static DataConverter getDefaultInstance() {
        return DefaultDataConverter.getDefaultInstance();
    }

    public <T> Optional<Payload> toPayload(T var1);

    public <T> T fromPayload(Payload var1, Class<T> var2, Type var3);

    public Optional<Payloads> toPayloads(Object ... var1) throws DataConverterException;

    public <T> T fromPayloads(int var1, Optional<Payloads> var2, Class<T> var3, Type var4) throws DataConverterException;

    public static Object[] arrayFromPayloads(DataConverter converter, Optional<Payloads> content, Class<?>[] parameterTypes, Type[] genericParameterTypes) throws DataConverterException {
        if (parameterTypes != null && (genericParameterTypes == null || parameterTypes.length != genericParameterTypes.length)) {
            throw new IllegalArgumentException("parameterTypes don't match length of valueTypes: " + Arrays.toString(parameterTypes) + "<>" + Arrays.toString(genericParameterTypes));
        }
        int length = parameterTypes.length;
        Object[] result = new Object[length];
        if (!content.isPresent()) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                result[i] = Defaults.defaultValue((Class)((Class)genericParameterTypes[i]));
            }
            return result;
        }
        Payloads payloads = content.get();
        int count = payloads.getPayloadsCount();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> pt = parameterTypes[i];
            Type gt = genericParameterTypes[i];
            result[i] = i >= count ? Defaults.defaultValue((Class)((Class)gt)) : converter.fromPayload(payloads.getPayloads(i), pt, gt);
        }
        return result;
    }
}

