/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.common.SearchAttribute;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.internal.common.ProtoEnumNameUtils;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SearchAttributePayloadConverter {
    private static final Logger log = LoggerFactory.getLogger(SearchAttributePayloadConverter.class);
    private static final String METADATA_TYPE_KEY = "type";
    private final DefaultDataConverter defaultDataConverter = DefaultDataConverter.newDefaultInstance();
    public static final SearchAttributePayloadConverter INSTANCE = new SearchAttributePayloadConverter();

    SearchAttributePayloadConverter() {
    }

    public Payload encode(@Nonnull Object instance) {
        if (instance instanceof Collection && ((Collection)instance).size() == 1) {
            instance = ((Collection)instance).iterator().next();
        }
        if (instance instanceof Payload) {
            return (Payload)instance;
        }
        Payload payload = this.defaultDataConverter.toPayload(instance).get();
        IndexedValueType type = SearchAttributePayloadConverter.extractIndexValueTypeName(instance);
        if (type == null) {
            return payload;
        }
        if (IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED.equals((Object)type)) {
            log.warn("Instance {} of class {} is not one of the types supported as a search attribute. For backwards compatibility we do the best effort to serialize it, but it may cause a WorkflowTask failure after server validation.", instance, instance.getClass());
        }
        return payload.toBuilder().putMetadata(METADATA_TYPE_KEY, ByteString.copyFromUtf8((String)SearchAttributePayloadConverter.indexValueTypeToEncodedValue(type))).build();
    }

    @Nonnull
    public List<?> decode(@Nonnull Payload payload) {
        ByteString dataType = (ByteString)payload.getMetadataMap().get(METADATA_TYPE_KEY);
        IndexedValueType indexType = SearchAttributePayloadConverter.getIndexType(dataType);
        if (SearchAttributePayloadConverter.isIndexTypeUndefined(indexType)) {
            if (this.isUnset(payload)) {
                return SearchAttribute.UNSET_VALUE;
            }
            log.warn("Absent or unexpected search attribute type metadata in a payload: {}", (Object)payload);
            return Collections.singletonList(payload);
        }
        return this.decodeAsType(payload, indexType);
    }

    @Nonnull
    public List<?> decodeAsType(@Nonnull Payload payload, @Nonnull IndexedValueType indexType) throws DataConverterException {
        Preconditions.checkArgument((!SearchAttributePayloadConverter.isIndexTypeUndefined(indexType) ? 1 : 0) != 0, (String)"indexType can't be %s", (Object)indexType);
        ByteString data = payload.getData();
        if (data.isEmpty()) {
            log.warn("No data in payload: {}", (Object)payload);
            return Collections.singletonList(payload);
        }
        Class<?> type = SearchAttributePayloadConverter.indexValueTypeToJavaType(indexType);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        try {
            return Collections.singletonList(this.defaultDataConverter.fromPayload(payload, type, type));
        }
        catch (Exception e) {
            try {
                return this.defaultDataConverter.fromPayload(payload, List.class, this.createListType(type));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Payload " + data.toStringUtf8() + " can't be deserialized into a single value or a list of " + type, ex);
            }
        }
    }

    private boolean isUnset(@Nonnull Payload payload) {
        try {
            List o = this.defaultDataConverter.fromPayload(payload, List.class, (Type)((Object)List.class));
            if (o.size() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static IndexedValueType getIndexType(ByteString dataType) {
        String dataTypeString;
        if (dataType != null && (dataTypeString = dataType.toStringUtf8()).length() != 0) {
            return SearchAttributePayloadConverter.encodedValueToIndexValueType(dataTypeString);
        }
        return null;
    }

    @Nullable
    private static IndexedValueType extractIndexValueTypeName(@Nonnull Object instance) {
        if (instance instanceof Collection) {
            Collection collection = (Collection)instance;
            if (!collection.isEmpty()) {
                List indexValues = collection.stream().map(k -> SearchAttributePayloadConverter.javaTypeToIndexValueType(k.getClass())).distinct().collect(Collectors.toList());
                if (indexValues.size() == 1) {
                    return (IndexedValueType)indexValues.get(0);
                }
                throw new IllegalArgumentException(instance + " maps into a mix of IndexValueTypes: " + indexValues);
            }
            return null;
        }
        return SearchAttributePayloadConverter.javaTypeToIndexValueType(instance.getClass());
    }

    @Nonnull
    private static IndexedValueType javaTypeToIndexValueType(@Nonnull Class<?> type) {
        if (CharSequence.class.isAssignableFrom(type)) {
            return IndexedValueType.INDEXED_VALUE_TYPE_TEXT;
        }
        if (Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type)) {
            return IndexedValueType.INDEXED_VALUE_TYPE_INT;
        }
        if (Double.class.equals(type) || Float.class.equals(type)) {
            return IndexedValueType.INDEXED_VALUE_TYPE_DOUBLE;
        }
        if (Boolean.class.equals(type)) {
            return IndexedValueType.INDEXED_VALUE_TYPE_BOOL;
        }
        if (OffsetDateTime.class.equals(type)) {
            return IndexedValueType.INDEXED_VALUE_TYPE_DATETIME;
        }
        return IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED;
    }

    @Nullable
    private static Class<?> indexValueTypeToJavaType(@Nullable IndexedValueType indexedValueType) {
        if (indexedValueType == null) {
            return null;
        }
        switch (indexedValueType) {
            case INDEXED_VALUE_TYPE_TEXT: 
            case INDEXED_VALUE_TYPE_KEYWORD: {
                return String.class;
            }
            case INDEXED_VALUE_TYPE_INT: {
                return Long.class;
            }
            case INDEXED_VALUE_TYPE_DOUBLE: {
                return Double.class;
            }
            case INDEXED_VALUE_TYPE_BOOL: {
                return Boolean.class;
            }
            case INDEXED_VALUE_TYPE_DATETIME: {
                return OffsetDateTime.class;
            }
            case INDEXED_VALUE_TYPE_UNSPECIFIED: {
                return null;
            }
        }
        log.warn("[BUG] Mapping of IndexedValueType[{}] to Java class is not implemented", (Object)indexedValueType);
        return null;
    }

    private static boolean isIndexTypeUndefined(@Nullable IndexedValueType indexType) {
        return indexType == null || indexType.equals((Object)IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED) || indexType.equals((Object)IndexedValueType.UNRECOGNIZED);
    }

    private static String indexValueTypeToEncodedValue(@Nonnull IndexedValueType indexedValueType) {
        return ProtoEnumNameUtils.uniqueToSimplifiedName(indexedValueType);
    }

    @Nullable
    private static IndexedValueType encodedValueToIndexValueType(String encodedValue) {
        try {
            return IndexedValueType.valueOf((String)ProtoEnumNameUtils.simplifiedToUniqueName(encodedValue, "INDEXED_VALUE_TYPE_"));
        }
        catch (IllegalArgumentException e) {
            log.warn("[BUG] No IndexedValueType mapping for {} value exist", (Object)encodedValue);
            return null;
        }
    }

    private <K> Type createListType(Class<K> elementType) {
        return new TypeToken<List<K>>(){}.where(new TypeParameter<K>(){}, elementType).getType();
    }
}

