/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.Functions;
import io.temporal.workflow.QueueConsumer;
import io.temporal.workflow.WorkflowQueue;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;

final class WorkflowQueueImpl<E>
implements WorkflowQueue<E> {
    private final Deque<E> queue = new ArrayDeque();
    private final int capacity;

    public WorkflowQueueImpl(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity less than 1: " + capacity);
        }
        this.capacity = capacity;
    }

    @Override
    public E take() {
        WorkflowThread.await("WorkflowQueue.take", () -> !this.queue.isEmpty());
        return this.queue.poll();
    }

    @Override
    public E cancellableTake() {
        WorkflowThread.await("WorkflowQueue.cancellableTake", () -> {
            CancellationScope.throwCanceled();
            return !this.queue.isEmpty();
        });
        return this.queue.poll();
    }

    @Override
    public E poll() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.remove();
    }

    @Override
    public E peek() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.peek();
    }

    @Override
    public E poll(Duration timeout) {
        WorkflowInternal.await(timeout, "WorkflowQueue.poll", () -> !this.queue.isEmpty());
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.remove();
    }

    @Override
    public E cancellablePoll(Duration timeout) {
        WorkflowInternal.await(timeout, "WorkflowQueue.cancellablePoll", () -> {
            CancellationScope.throwCanceled();
            return !this.queue.isEmpty();
        });
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.remove();
    }

    @Override
    public boolean offer(E e) {
        if (this.queue.size() == this.capacity) {
            return false;
        }
        this.queue.addLast(e);
        return true;
    }

    @Override
    public void put(E e) {
        WorkflowThread.await("WorkflowQueue.put", () -> this.queue.size() < this.capacity);
        this.queue.addLast(e);
    }

    @Override
    public void cancellablePut(E e) {
        WorkflowThread.await("WorkflowQueue.cancellablePut", () -> {
            CancellationScope.throwCanceled();
            return this.queue.size() < this.capacity;
        });
        this.queue.addLast(e);
    }

    @Override
    public boolean offer(E e, Duration timeout) {
        WorkflowInternal.await(timeout, "WorkflowQueue.offer", () -> this.queue.size() < this.capacity);
        if (this.queue.size() >= this.capacity) {
            return false;
        }
        this.queue.addLast(e);
        return true;
    }

    @Override
    public boolean cancellableOffer(E e, Duration timeout) {
        WorkflowInternal.await(timeout, "WorkflowQueue.cancellableOffer", () -> this.queue.size() < this.capacity);
        if (this.queue.size() >= this.capacity) {
            return false;
        }
        this.queue.addLast(e);
        return true;
    }

    @Override
    public <R> QueueConsumer<R> map(Functions.Func1<? super E, ? extends R> mapper) {
        return new MappedQueueConsumer<R, E>(this, mapper);
    }

    private static class MappedQueueConsumer<R, E>
    implements QueueConsumer<R> {
        private final QueueConsumer<E> source;
        private final Functions.Func1<? super E, ? extends R> mapper;

        public MappedQueueConsumer(QueueConsumer<E> source, Functions.Func1<? super E, ? extends R> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public R take() {
            E element = this.source.take();
            return this.mapper.apply(element);
        }

        @Override
        public R cancellableTake() {
            E element = this.source.cancellableTake();
            return this.mapper.apply(element);
        }

        @Override
        public R poll() {
            E element = this.source.poll();
            if (element == null) {
                return null;
            }
            return this.mapper.apply(element);
        }

        @Override
        public R peek() {
            E element = this.source.peek();
            if (element == null) {
                return null;
            }
            return this.mapper.apply(element);
        }

        @Override
        public R poll(Duration timeout) {
            E element = this.source.poll(timeout);
            if (element == null) {
                return null;
            }
            return this.mapper.apply(element);
        }

        @Override
        public R cancellablePoll(Duration timeout) {
            E element = this.source.cancellablePoll(timeout);
            if (element == null) {
                return null;
            }
            return this.mapper.apply(element);
        }

        @Override
        public <R1> QueueConsumer<R1> map(Functions.Func1<? super R, ? extends R1> mapper) {
            return new MappedQueueConsumer<R1, R>(this, mapper);
        }
    }
}

