/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.common.RetryOptions;
import io.temporal.failure.ApplicationFailure;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.internal.worker.LocalActivityPollTask;
import io.temporal.internal.worker.NoopSuspendableWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.internal.worker.activity.ActivityWorkerHelper;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.worker.WorkerMetricsTag;
import io.temporal.workflow.Functions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public final class LocalActivityWorker
implements SuspendableWorker {
    @Nonnull
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private final ActivityTaskHandler handler;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final LocalActivityPollTask laPollTask;
    private final PollerOptions pollerOptions;
    private final Scope workerMetricsScope;

    public LocalActivityWorker(@Nonnull String namespace, @Nonnull String taskQueue, @Nonnull SingleWorkerOptions options, @Nonnull ActivityTaskHandler handler) {
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.handler = handler;
        this.laPollTask = new LocalActivityPollTask();
        this.options = Objects.requireNonNull(options);
        this.pollerOptions = this.getPollerOptions(options);
        this.workerMetricsScope = MetricsTag.tagged((Scope)options.getMetricsScope(), (MetricsTag.TagValue)WorkerMetricsTag.WorkerType.LOCAL_ACTIVITY_WORKER);
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            PollTaskExecutor<Task> pollTaskExecutor = new PollTaskExecutor<Task>(this.namespace, this.taskQueue, this.options.getIdentity(), new TaskHandlerImpl(this.handler), this.pollerOptions, this.options.getTaskExecutorThreadPoolSize(), this.workerMetricsScope);
            this.poller = new Poller<Task>(this.options.getIdentity(), this.laPollTask, pollTaskExecutor, this.pollerOptions, this.workerMetricsScope);
            this.poller.start();
            this.workerMetricsScope.counter("temporal_worker_start").inc(1L);
        }
    }

    public boolean isAnyTypeSupported() {
        return this.handler.isAnyTypeSupported();
    }

    @Override
    public boolean isStarted() {
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return this.poller.shutdown(shutdownManager, interruptTasks);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    private PollerOptions getPollerOptions(SingleWorkerOptions options) {
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix(WorkerThreadsNameHelper.getLocalActivityPollerThreadPrefix(this.namespace, this.taskQueue)).build();
        }
        return pollerOptions;
    }

    public BiFunction<Task, java.time.Duration, Boolean> getLocalActivityTaskPoller() {
        return this.laPollTask;
    }

    static RetryOptions buildRetryOptions(RetryPolicy retryPolicy) {
        java.time.Duration initialInterval;
        Object[] doNotRetry = new String[retryPolicy.getNonRetryableErrorTypesCount()];
        retryPolicy.getNonRetryableErrorTypesList().toArray(doNotRetry);
        RetryOptions.Builder roBuilder = RetryOptions.newBuilder();
        java.time.Duration maximumInterval = ProtobufTimeUtils.toJavaDuration(retryPolicy.getMaximumInterval());
        if (!maximumInterval.isZero()) {
            roBuilder.setMaximumInterval(maximumInterval);
        }
        if (!(initialInterval = ProtobufTimeUtils.toJavaDuration(retryPolicy.getInitialInterval())).isZero()) {
            roBuilder.setInitialInterval(initialInterval);
        }
        if (retryPolicy.getBackoffCoefficient() >= 1.0) {
            roBuilder.setBackoffCoefficient(retryPolicy.getBackoffCoefficient());
        }
        if (retryPolicy.getMaximumAttempts() > 0) {
            roBuilder.setMaximumAttempts(retryPolicy.getMaximumAttempts());
        }
        return roBuilder.setDoNotRetry((String[])doNotRetry).validateBuildWithDefaults();
    }

    private static boolean isNonRetryableApplicationFailure(ActivityTaskHandler.Result result) {
        return result.getTaskFailed() != null && result.getTaskFailed().getFailure() != null && result.getTaskFailed().getFailure() instanceof ApplicationFailure && ((ApplicationFailure)result.getTaskFailed().getFailure()).isNonRetryable();
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<Task> {
        final ActivityTaskHandler handler;

        private TaskHandlerImpl(ActivityTaskHandler handler) {
            this.handler = handler;
        }

        @Override
        public void handle(Task task) throws Exception {
            task.taskStartTime = System.currentTimeMillis();
            ActivityTaskHandler.Result result = this.handleLocalActivity(task);
            task.eventConsumer.apply(result);
        }

        @Override
        public Throwable wrapFailure(Task task, Throwable failure) {
            return new RuntimeException("Failure processing local activity task.", failure);
        }

        private ActivityTaskHandler.Result handleLocalActivity(Task task) throws InterruptedException {
            Optional<java.time.Duration> expiration;
            ExecuteLocalActivityParameters params = task.params;
            PollActivityTaskQueueResponse.Builder activityTask = params.getActivityTask();
            ImmutableMap activityTypeTag = new ImmutableMap.Builder(1).put((Object)"activity_type", (Object)activityTask.getActivityType().getName()).put((Object)"workflow_type", (Object)activityTask.getWorkflowType().getName()).build();
            Scope metricsScope = LocalActivityWorker.this.workerMetricsScope.tagged((Map)activityTypeTag);
            metricsScope.counter("temporal_local_activity_total").inc(1L);
            if (activityTask.hasHeader()) {
                ActivityWorkerHelper.deserializeAndPopulateContext(activityTask.getHeader(), LocalActivityWorker.this.options.getContextPropagators());
            }
            Stopwatch sw = metricsScope.timer("temporal_local_activity_execution_latency").start();
            ActivityTaskHandler.Result result = this.handler.handle(new ActivityTask(activityTask.build(), () -> {}), metricsScope, true);
            sw.stop();
            int attempt = activityTask.getAttempt();
            result.setAttempt(attempt);
            if (LocalActivityWorker.isNonRetryableApplicationFailure(result)) {
                return result;
            }
            if (result.getTaskCompleted() != null) {
                Duration e2eDuration = ProtobufTimeUtils.toM3DurationSinceNow(task.params.getActivityTask().getScheduledTime());
                metricsScope.timer("temporal_local_activity_succeed_endtoend_latency").record(e2eDuration);
            }
            if (result.getTaskCompleted() != null || result.getTaskCanceled() != null || !activityTask.hasRetryPolicy()) {
                return result;
            }
            RetryOptions retryOptions = LocalActivityWorker.buildRetryOptions(activityTask.getRetryPolicy());
            long sleepMillis = retryOptions.calculateSleepTime(attempt);
            long elapsedTask = System.currentTimeMillis() - task.taskStartTime;
            long sinceScheduled = System.currentTimeMillis() - Timestamps.toMillis((Timestamp)activityTask.getScheduledTime());
            long elapsedTotal = elapsedTask + sinceScheduled;
            java.time.Duration timeout = ProtobufTimeUtils.toJavaDuration(activityTask.getScheduleToCloseTimeout());
            Optional<java.time.Duration> optional = expiration = timeout.compareTo(java.time.Duration.ZERO) > 0 ? Optional.of(timeout) : Optional.empty();
            if (retryOptions.shouldRethrow(result.getTaskFailed().getFailure(), expiration, attempt, elapsedTotal, sleepMillis)) {
                return result;
            }
            result.setBackoff(java.time.Duration.ofMillis(sleepMillis));
            if (elapsedTask + sleepMillis < task.params.getLocalRetryThreshold().toMillis()) {
                Thread.sleep(sleepMillis);
                activityTask.setAttempt(attempt + 1);
                return this.handleLocalActivity(task);
            }
            return result;
        }
    }

    public static class Task {
        private final ExecuteLocalActivityParameters params;
        private final Functions.Proc1<ActivityTaskHandler.Result> eventConsumer;
        long taskStartTime;

        public Task(ExecuteLocalActivityParameters params, Functions.Proc1<ActivityTaskHandler.Result> eventConsumer) {
            this.params = params;
            this.eventConsumer = eventConsumer;
        }

        public String getActivityId() {
            return this.params.getActivityTask().getActivityId();
        }
    }
}

