/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.WorkflowPollTask;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;
import java.util.function.Supplier;

public class WorkflowPollTaskFactory
implements Supplier<Poller.PollTask<PollWorkflowTaskQueueResponse>> {
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final Scope metricScope;
    private final String identity;
    private final String binaryChecksum;

    public WorkflowPollTaskFactory(WorkflowServiceStubs service, String namespace, String taskQueue, Scope metricScope, String identity, String binaryChecksum) {
        this.service = Objects.requireNonNull(service, "service should not be null");
        this.namespace = Objects.requireNonNull(namespace, "namespace should not be null");
        this.taskQueue = Objects.requireNonNull(taskQueue, "taskQueue should not be null");
        this.metricScope = Objects.requireNonNull(metricScope, "metricScope should not be null");
        this.identity = Objects.requireNonNull(identity, "identity should not be null");
        this.binaryChecksum = binaryChecksum;
    }

    @Override
    public Poller.PollTask<PollWorkflowTaskQueueResponse> get() {
        return new WorkflowPollTask(this.service, this.namespace, this.taskQueue, this.identity, this.binaryChecksum, this.metricScope);
    }
}

