/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.RetryOptions;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ChildWorkflowStub;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.ExternalWorkflowStub;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.WorkflowQueue;
import io.temporal.workflow.unsafe.WorkflowUnsafe;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public final class Workflow {
    public static final int DEFAULT_VERSION = -1;

    public static <T> T newActivityStub(Class<T> activityInterface) {
        return WorkflowInternal.newActivityStub(activityInterface, null, null);
    }

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options) {
        return WorkflowInternal.newActivityStub(activityInterface, options, null);
    }

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options, Map<String, ActivityOptions> activityMethodOptions) {
        return WorkflowInternal.newActivityStub(activityInterface, options, activityMethodOptions);
    }

    public static ActivityStub newUntypedActivityStub(ActivityOptions options) {
        return WorkflowInternal.newUntypedActivityStub(options);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface) {
        return WorkflowInternal.newLocalActivityStub(activityInterface, null, null);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options) {
        return WorkflowInternal.newLocalActivityStub(activityInterface, options, null);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options, Map<String, LocalActivityOptions> activityMethodOptions) {
        return WorkflowInternal.newLocalActivityStub(activityInterface, options, activityMethodOptions);
    }

    public static ActivityStub newUntypedLocalActivityStub(LocalActivityOptions options) {
        return WorkflowInternal.newUntypedLocalActivityStub(options);
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface) {
        return WorkflowInternal.newChildWorkflowStub(workflowInterface, null);
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface, ChildWorkflowOptions options) {
        return WorkflowInternal.newChildWorkflowStub(workflowInterface, options);
    }

    public static <R> R newExternalWorkflowStub(Class<? extends R> workflowInterface, String workflowId) {
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).build();
        return WorkflowInternal.newExternalWorkflowStub(workflowInterface, execution);
    }

    public static <R> R newExternalWorkflowStub(Class<? extends R> workflowInterface, WorkflowExecution execution) {
        return WorkflowInternal.newExternalWorkflowStub(workflowInterface, execution);
    }

    public static Promise<WorkflowExecution> getWorkflowExecution(Object childWorkflowStub) {
        return WorkflowInternal.getWorkflowExecution(childWorkflowStub);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType, ChildWorkflowOptions options) {
        return WorkflowInternal.newUntypedChildWorkflowStub(workflowType, options);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType) {
        return WorkflowInternal.newUntypedChildWorkflowStub(workflowType, null);
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(WorkflowExecution execution) {
        return WorkflowInternal.newUntypedExternalWorkflowStub(execution);
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(String workflowId) {
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).build();
        return Workflow.newUntypedExternalWorkflowStub(execution);
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface, ContinueAsNewOptions options) {
        return WorkflowInternal.newContinueAsNewStub(workflowInterface, options);
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface) {
        return WorkflowInternal.newContinueAsNewStub(workflowInterface, null);
    }

    public static void continueAsNew(Object ... args) {
        Workflow.continueAsNew(null, args);
    }

    public static void continueAsNew(@Nullable ContinueAsNewOptions options, Object ... args) {
        Workflow.continueAsNew(null, options, args);
    }

    @Deprecated
    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object ... args) {
        WorkflowInternal.continueAsNew(workflowType.orElse(null), options.orElse(null), args);
    }

    public static void continueAsNew(@Nullable String workflowType, @Nullable ContinueAsNewOptions options, Object ... args) {
        WorkflowInternal.continueAsNew(workflowType, options, args);
    }

    public static WorkflowInfo getInfo() {
        return WorkflowInternal.getWorkflowInfo();
    }

    public static <T> Object getMemo(String key, Class<T> valueClass) {
        return Workflow.getMemo(key, valueClass, valueClass);
    }

    public static <T> T getMemo(String key, Class<T> valueClass, Type genericType) {
        return WorkflowInternal.getMemo(key, valueClass, genericType);
    }

    public static CancellationScope newCancellationScope(Runnable runnable) {
        return WorkflowInternal.newCancellationScope(false, runnable);
    }

    public static CancellationScope newCancellationScope(Functions.Proc1<CancellationScope> proc) {
        return WorkflowInternal.newCancellationScope(false, proc);
    }

    public static CancellationScope newDetachedCancellationScope(Runnable runnable) {
        return WorkflowInternal.newCancellationScope(true, runnable);
    }

    public static Promise<Void> newTimer(Duration delay) {
        return WorkflowInternal.newTimer(delay);
    }

    @Deprecated
    public static <E> WorkflowQueue<E> newQueue(int capacity) {
        return WorkflowInternal.newQueue(capacity);
    }

    public static <E> WorkflowQueue<E> newWorkflowQueue(int capacity) {
        return WorkflowInternal.newWorkflowQueue(capacity);
    }

    public static <E> CompletablePromise<E> newPromise() {
        return WorkflowInternal.newCompletablePromise();
    }

    public static <E> Promise<E> newPromise(E value) {
        return WorkflowInternal.newPromise(value);
    }

    public static <E> Promise<E> newFailedPromise(Exception failure) {
        return WorkflowInternal.newFailedPromise(failure);
    }

    public static void registerListener(Object listener) {
        WorkflowInternal.registerListener(listener);
    }

    public static long currentTimeMillis() {
        return WorkflowInternal.currentTimeMillis();
    }

    public static void sleep(Duration duration) {
        WorkflowInternal.sleep(duration);
    }

    public static void sleep(long millis) {
        WorkflowInternal.sleep(Duration.ofMillis(millis));
    }

    public static void await(Supplier<Boolean> unblockCondition) {
        WorkflowInternal.await("await", () -> {
            CancellationScope.throwCanceled();
            return (Boolean)unblockCondition.get();
        });
    }

    public static boolean await(Duration timeout, Supplier<Boolean> unblockCondition) {
        return WorkflowInternal.await(timeout, "await", () -> {
            CancellationScope.throwCanceled();
            return (Boolean)unblockCondition.get();
        });
    }

    public static <R> R retry(RetryOptions options, Optional<Duration> expiration, Functions.Func<R> fn) {
        return WorkflowInternal.retry(options, expiration, fn);
    }

    public static void retry(RetryOptions options, Optional<Duration> expiration, Functions.Proc proc) {
        WorkflowInternal.retry(options, expiration, () -> {
            proc.apply();
            return null;
        });
    }

    public static RuntimeException wrap(Exception e) {
        return WorkflowInternal.wrap(e);
    }

    public static UUID randomUUID() {
        return WorkflowInternal.randomUUID();
    }

    public static Random newRandom() {
        return WorkflowInternal.newRandom();
    }

    @Deprecated
    public static boolean isReplaying() {
        return WorkflowUnsafe.isReplaying();
    }

    public static <R> R sideEffect(Class<R> resultClass, Functions.Func<R> func) {
        return WorkflowInternal.sideEffect(resultClass, resultClass, func);
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        return WorkflowInternal.sideEffect(resultClass, resultType, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.mutableSideEffect(id, resultClass, resultClass, updated, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.mutableSideEffect(id, resultClass, resultType, updated, func);
    }

    public static int getVersion(String changeId, int minSupported, int maxSupported) {
        return WorkflowInternal.getVersion(changeId, minSupported, maxSupported);
    }

    public static Scope getMetricsScope() {
        return WorkflowInternal.getMetricsScope();
    }

    public static Logger getLogger(Class<?> clazz) {
        return WorkflowInternal.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return WorkflowInternal.getLogger(name);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass) {
        return WorkflowInternal.getLastCompletionResult(resultClass, resultClass);
    }

    public static Optional<Exception> getPreviousRunFailure() {
        return WorkflowInternal.getPreviousRunFailure();
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return WorkflowInternal.getLastCompletionResult(resultClass, resultType);
    }

    @Nullable
    public static <T> T getSearchAttribute(String name) {
        return WorkflowInternal.getSearchAttribute(name);
    }

    @Nullable
    public static <T> List<T> getSearchAttributeValues(String name) {
        return WorkflowInternal.getSearchAttributeValues(name);
    }

    @Nonnull
    public static Map<String, List<?>> getSearchAttributes() {
        return WorkflowInternal.getSearchAttributes();
    }

    public static void upsertSearchAttributes(Map<String, ?> searchAttributes) {
        WorkflowInternal.upsertSearchAttributes(searchAttributes);
    }

    public static void setDefaultActivityOptions(ActivityOptions defaultActivityOptions) {
        WorkflowInternal.setDefaultActivityOptions(defaultActivityOptions);
    }

    @Deprecated
    public static void setActivityOptions(Map<String, ActivityOptions> activityMethodOptions) {
        WorkflowInternal.applyActivityOptions(activityMethodOptions);
    }

    public static void applyActivityOptions(Map<String, ActivityOptions> activityTypeToOptions) {
        WorkflowInternal.applyActivityOptions(activityTypeToOptions);
    }

    public static void setDefaultLocalActivityOptions(LocalActivityOptions defaultLocalActivityOptions) {
        WorkflowInternal.setDefaultLocalActivityOptions(defaultLocalActivityOptions);
    }

    public static void applyLocalActivityOptions(Map<String, LocalActivityOptions> activityTypeToOptions) {
        WorkflowInternal.applyLocalActivityOptions(activityTypeToOptions);
    }

    private Workflow() {
    }
}

