/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.failure;

import io.temporal.api.enums.v1.RetryState;
import io.temporal.failure.TemporalFailure;

public final class ActivityFailure
extends TemporalFailure {
    private final long scheduledEventId;
    private final long startedEventId;
    private final String activityType;
    private final String activityId;
    private final String identity;
    private final RetryState retryState;

    public ActivityFailure(long scheduledEventId, long startedEventId, String activityType, String activityId, RetryState retryState, String identity, Throwable cause) {
        super(ActivityFailure.getMessage(scheduledEventId, startedEventId, activityType, activityId, retryState, identity), null, cause);
        this.scheduledEventId = scheduledEventId;
        this.startedEventId = startedEventId;
        this.activityType = activityType;
        this.activityId = activityId;
        this.identity = identity;
        this.retryState = retryState;
    }

    public long getScheduledEventId() {
        return this.scheduledEventId;
    }

    public long getStartedEventId() {
        return this.startedEventId;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getIdentity() {
        return this.identity;
    }

    public RetryState getRetryState() {
        return this.retryState;
    }

    public static String getMessage(long scheduledEventId, long startedEventId, String activityType, String activityId, RetryState retryState, String identity) {
        return "scheduledEventId=" + scheduledEventId + ", startedEventId=" + startedEventId + ", activityType='" + activityType + '\'' + (activityId == null ? "" : ", activityId='" + activityId + '\'') + ", identity='" + identity + '\'' + ", retryState=" + retryState;
    }
}

