/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client.external;

import com.google.common.util.concurrent.ListenableFuture;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.grpc.Deadline;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.rpcretry.DefaultStubLongPollRpcRetryOptions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Nonnull;

public final class GenericWorkflowClientImpl
implements GenericWorkflowClient {
    private static final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "generic-wf-client-async-throttler"));
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;
    private final GrpcRetryer grpcRetryer;
    private final GrpcRetryer.GrpcRetryerOptions grpcRetryerOptions;

    public GenericWorkflowClientImpl(WorkflowServiceStubs service, Scope metricsScope) {
        this.service = service;
        this.metricsScope = metricsScope;
        RpcRetryOptions rpcRetryOptions = RpcRetryOptions.newBuilder().buildWithDefaultsFrom(service.getOptions().getRpcRetryOptions());
        this.grpcRetryer = new GrpcRetryer(service.getServerCapabilities());
        this.grpcRetryerOptions = new GrpcRetryer.GrpcRetryerOptions(rpcRetryOptions, null);
    }

    @Override
    public WorkflowExecution start(StartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        StartWorkflowExecutionResponse result = (StartWorkflowExecutionResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).startWorkflowExecution(request), this.grpcRetryerOptions);
        return WorkflowExecution.newBuilder().setRunId(result.getRunId()).setWorkflowId(request.getWorkflowId()).build();
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public WorkflowExecution signalWithStart(SignalWithStartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        SignalWithStartWorkflowExecutionResponse result = (SignalWithStartWorkflowExecutionResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWithStartWorkflowExecution(request), this.grpcRetryerOptions);
        return WorkflowExecution.newBuilder().setRunId(result.getRunId()).setWorkflowId(request.getWorkflowId()).build();
    }

    @Override
    public void requestCancel(RequestCancelWorkflowExecutionRequest request) {
        this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).requestCancelWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public void terminate(TerminateWorkflowExecutionRequest request) {
        this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).terminateWorkflowExecution(request), this.grpcRetryerOptions);
    }

    @Override
    public GetWorkflowExecutionHistoryResponse longPollHistory(@Nonnull GetWorkflowExecutionHistoryRequest request, @Nonnull Deadline deadline) {
        return (GetWorkflowExecutionHistoryResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(deadline)).getWorkflowExecutionHistory(request), new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public CompletableFuture<GetWorkflowExecutionHistoryResponse> longPollHistoryAsync(@Nonnull GetWorkflowExecutionHistoryRequest request, @Nonnull Deadline deadline) {
        return this.grpcRetryer.retryWithResultAsync(executor, () -> {
            CompletableFuture result = new CompletableFuture();
            ListenableFuture resultFuture = ((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(deadline)).getWorkflowExecutionHistory(request);
            resultFuture.addListener(() -> {
                try {
                    result.complete((GetWorkflowExecutionHistoryResponse)resultFuture.get());
                }
                catch (ExecutionException e) {
                    result.completeExceptionally(e.getCause());
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            }, (Executor)ForkJoinPool.commonPool());
            return result;
        }, new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryParameters) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"query_type", (Object)queryParameters.getQuery().getQueryType()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return (QueryWorkflowResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).queryWorkflow(queryParameters), this.grpcRetryerOptions);
    }
}

