/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.uber.m3.tally.Scope;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.internal.replay.ReplayAware;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.StartChildWorkflowExecutionParameters;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;

public interface ReplayWorkflowContext
extends ReplayAware {
    public WorkflowExecution getWorkflowExecution();

    public WorkflowExecution getParentWorkflowExecution();

    public WorkflowType getWorkflowType();

    public boolean isCancelRequested();

    public ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion();

    public Optional<String> getContinuedExecutionRunId();

    public String getTaskQueue();

    public String getNamespace();

    public String getWorkflowId();

    public String getRunId();

    public Duration getWorkflowRunTimeout();

    public Duration getWorkflowExecutionTimeout();

    public long getRunStartedTimestampMillis();

    public Duration getWorkflowTaskTimeout();

    public Payload getMemo(String var1);

    @Nullable
    public SearchAttributes getSearchAttributes();

    public Functions.Proc1<Exception> scheduleActivityTask(ExecuteActivityParameters var1, Functions.Proc2<Optional<Payloads>, Failure> var2);

    public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters var1, Functions.Proc2<Optional<Payloads>, Failure> var2);

    public Functions.Proc1<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters var1, Functions.Proc2<WorkflowExecution, Exception> var2, Functions.Proc2<Optional<Payloads>, Exception> var3);

    public Functions.Proc1<Exception> signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes.Builder var1, Functions.Proc2<Void, Failure> var2);

    public void requestCancelExternalWorkflowExecution(WorkflowExecution var1, Functions.Proc2<Void, RuntimeException> var2);

    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes var1);

    public long currentTimeMillis();

    public Functions.Proc1<RuntimeException> newTimer(Duration var1, Functions.Proc1<RuntimeException> var2);

    public void sideEffect(Functions.Func<Optional<Payloads>> var1, Functions.Proc1<Optional<Payloads>> var2);

    public void mutableSideEffect(String var1, Functions.Func1<Optional<Payloads>, Optional<Payloads>> var2, Functions.Proc1<Optional<Payloads>> var3);

    public void getVersion(String var1, int var2, int var3, Functions.Proc2<Integer, RuntimeException> var4);

    public Random newRandom();

    public Scope getMetricsScope();

    public boolean getEnableLoggingInReplay();

    public UUID randomUUID();

    public void upsertSearchAttributes(SearchAttributes var1);

    public int getAttempt();

    public String getCronSchedule();

    @Nullable
    public Payloads getLastCompletionResult();

    @Nullable
    public Failure getPreviousRunFailure();

    @Nullable
    public String getFullReplayDirectQueryName();

    public Map<String, Payload> getHeader();
}

