/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import io.grpc.Deadline;
import io.temporal.api.command.v1.Command;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.QueryResultType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.query.v1.WorkflowQueryResult;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.QueryResult;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContextImpl;
import io.temporal.internal.replay.ReplayWorkflowExecutor;
import io.temporal.internal.replay.WorkflowHistoryIterator;
import io.temporal.internal.replay.WorkflowRunTaskHandler;
import io.temporal.internal.replay.WorkflowTaskResult;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.StatesMachinesCallback;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.internal.worker.LocalActivityTask;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;

class ReplayWorkflowRunTaskHandler
implements WorkflowRunTaskHandler {
    private final Scope metricsScope;
    private final WorkflowExecutionStartedEventAttributes startedEvent;
    private final Lock lock = new ReentrantLock();
    private final Functions.Proc1<ActivityTaskHandler.Result> localActivityCompletionSink;
    private final BlockingQueue<ActivityTaskHandler.Result> localActivityCompletionQueue = new LinkedBlockingDeque<ActivityTaskHandler.Result>();
    private final BiFunction<LocalActivityTask, java.time.Duration, Boolean> localActivityTaskPoller;
    private final ReplayWorkflow workflow;
    private final WorkflowStateMachines workflowStateMachines;
    private int localActivityTaskCount;
    private final ReplayWorkflowExecutor replayWorkflowExecutor;

    ReplayWorkflowRunTaskHandler(String namespace, ReplayWorkflow workflow, PollWorkflowTaskQueueResponseOrBuilder workflowTask, SingleWorkerOptions workerOptions, Scope metricsScope, BiFunction<LocalActivityTask, java.time.Duration, Boolean> localActivityTaskPoller) {
        HistoryEvent startedEvent = workflowTask.getHistory().getEvents(0);
        if (!startedEvent.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalArgumentException("First event in the history is not WorkflowExecutionStarted");
        }
        this.startedEvent = startedEvent.getWorkflowExecutionStartedEventAttributes();
        this.metricsScope = metricsScope;
        this.localActivityTaskPoller = localActivityTaskPoller;
        this.workflow = workflow;
        this.workflowStateMachines = new WorkflowStateMachines(new StatesMachinesCallbackImpl());
        String fullReplayDirectQueryType = workflowTask.hasQuery() ? workflowTask.getQuery().getQueryType() : null;
        ReplayWorkflowContextImpl context = new ReplayWorkflowContextImpl(this.workflowStateMachines, namespace, this.startedEvent, workflowTask.getWorkflowExecution(), Timestamps.toMillis((Timestamp)startedEvent.getEventTime()), fullReplayDirectQueryType, workerOptions, metricsScope);
        this.replayWorkflowExecutor = new ReplayWorkflowExecutor(workflow, this.workflowStateMachines, context);
        this.localActivityCompletionSink = this.localActivityCompletionQueue::add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTaskResult handleWorkflowTask(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowHistoryIterator historyIterator) throws InterruptedException {
        this.lock.lock();
        try {
            long startTimeNanos = System.nanoTime();
            if (workflowTask.getPreviousStartedEventId() < this.workflowStateMachines.getCurrentStartedEventId()) {
                throw new IllegalStateException("Server history for the workflow is below the progress of the workflow on the worker, the progress needs to be discarded");
            }
            this.handleWorkflowTaskImpl(workflowTask, historyIterator);
            this.processLocalActivityRequests(startTimeNanos);
            List<Command> commands = this.workflowStateMachines.takeCommands();
            if (this.replayWorkflowExecutor.isCompleted()) {
                this.close();
            }
            Map<String, WorkflowQueryResult> queryResults = this.executeQueries(workflowTask.getQueriesMap());
            WorkflowTaskResult workflowTaskResult = WorkflowTaskResult.newBuilder().setCommands(commands).setQueryResults(queryResults).setFinalCommand(this.replayWorkflowExecutor.isCompleted()).setForceWorkflowTask(this.localActivityTaskCount > 0 && !this.replayWorkflowExecutor.isCompleted()).build();
            return workflowTaskResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult handleDirectQueryWorkflowTask(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowHistoryIterator historyIterator) {
        WorkflowQuery query = workflowTask.getQuery();
        this.lock.lock();
        try {
            this.handleWorkflowTaskImpl(workflowTask, historyIterator);
            if (this.replayWorkflowExecutor.isCompleted()) {
                this.close();
            }
            Optional<Payloads> resultPayloads = this.replayWorkflowExecutor.query(query);
            QueryResult queryResult = new QueryResult(resultPayloads, this.replayWorkflowExecutor.isCompleted());
            return queryResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleWorkflowTaskImpl(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowHistoryIterator historyIterator) {
        this.workflowStateMachines.setWorklfowStartedEventId(workflowTask.getStartedEventId());
        this.workflowStateMachines.setReplaying(workflowTask.getPreviousStartedEventId() > 0L);
        this.applyServerHistory(historyIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyServerHistory(WorkflowHistoryIterator historyIterator) {
        java.time.Duration expiration = ProtobufTimeUtils.toJavaDuration(this.startedEvent.getWorkflowTaskTimeout());
        historyIterator.initDeadline(Deadline.after((long)expiration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        boolean timerStopped = false;
        Stopwatch sw = this.metricsScope.timer("temporal_workflow_task_replay_latency").start();
        try {
            while (historyIterator.hasNext()) {
                HistoryEvent event = (HistoryEvent)historyIterator.next();
                boolean hasNext = historyIterator.hasNext();
                try {
                    this.workflowStateMachines.handleEvent(event, hasNext);
                }
                catch (Throwable e) {
                    Class<? extends Throwable>[] failTypes;
                    WorkflowImplementationOptions implementationOptions = this.workflow.getWorkflowContext().getWorkflowImplementationOptions();
                    for (Class<? extends Throwable> failType : failTypes = implementationOptions.getFailWorkflowExceptionTypes()) {
                        if (!failType.isAssignableFrom(e.getClass())) continue;
                        throw new WorkflowExecutionException(this.workflow.getWorkflowContext().mapExceptionToFailure(e));
                    }
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
                if (timerStopped || this.workflowStateMachines.isReplaying()) continue;
                sw.stop();
                timerStopped = true;
            }
        }
        finally {
            if (!timerStopped) {
                sw.stop();
            }
        }
    }

    private Map<String, WorkflowQueryResult> executeQueries(Map<String, WorkflowQuery> queries) {
        HashMap<String, WorkflowQueryResult> queryResults = new HashMap<String, WorkflowQueryResult>();
        for (Map.Entry<String, WorkflowQuery> entry : queries.entrySet()) {
            WorkflowQuery query = entry.getValue();
            try {
                Optional<Payloads> queryResult = this.replayWorkflowExecutor.query(query);
                WorkflowQueryResult.Builder result = WorkflowQueryResult.newBuilder().setResultType(QueryResultType.QUERY_RESULT_TYPE_ANSWERED);
                if (queryResult.isPresent()) {
                    result.setAnswer(queryResult.get());
                }
                queryResults.put(entry.getKey(), result.build());
            }
            catch (Exception e) {
                String stackTrace = Throwables.getStackTraceAsString((Throwable)e);
                queryResults.put(entry.getKey(), WorkflowQueryResult.newBuilder().setResultType(QueryResultType.QUERY_RESULT_TYPE_FAILED).setErrorMessage(e + "\n" + stackTrace).build());
            }
        }
        return queryResults;
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.replayWorkflowExecutor.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processLocalActivityRequests(long startTimeNs) throws InterruptedException {
        long durationUntilWFTHeartbeatNs = (long)((double)Durations.toNanos((Duration)this.startedEvent.getWorkflowTaskTimeout()) * 0.8);
        long nextWFTHeartbeatTimeNs = startTimeNs + durationUntilWFTHeartbeatNs;
        while (true) {
            long maxWaitTimeTillHeartbeatNs;
            ActivityTaskHandler.Result laCompletion;
            List<ExecuteLocalActivityParameters> laRequests = this.workflowStateMachines.takeLocalActivityRequests();
            this.localActivityTaskCount += laRequests.size();
            for (ExecuteLocalActivityParameters laRequest : laRequests) {
                long maxWaitTimeNs = Math.max(nextWFTHeartbeatTimeNs - System.nanoTime(), 0L);
                boolean accepted = this.localActivityTaskPoller.apply(new LocalActivityTask(laRequest, this.localActivityCompletionSink), java.time.Duration.ofNanos(maxWaitTimeNs));
                Preconditions.checkState((boolean)accepted, (Object)"Unable to schedule local activity for execution, no more slots available and local activity task queue is full");
            }
            if (this.localActivityTaskCount == 0 || (laCompletion = this.localActivityCompletionQueue.poll(maxWaitTimeTillHeartbeatNs = Math.max(nextWFTHeartbeatTimeNs - System.nanoTime(), 0L), TimeUnit.NANOSECONDS)) == null) break;
            --this.localActivityTaskCount;
            this.workflowStateMachines.handleLocalActivityCompletion(laCompletion);
        }
        Preconditions.checkState((boolean)this.workflowStateMachines.takeLocalActivityRequests().isEmpty(), (Object)"[BUG] Local activities requests from the last event loop were not drained and accounted in the outstanding local activities counter");
    }

    @VisibleForTesting
    WorkflowStateMachines getWorkflowStateMachines() {
        return this.workflowStateMachines;
    }

    private class StatesMachinesCallbackImpl
    implements StatesMachinesCallback {
        private StatesMachinesCallbackImpl() {
        }

        @Override
        public void start(HistoryEvent startWorkflowEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.start(startWorkflowEvent);
        }

        @Override
        public void eventLoop() {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.eventLoop();
        }

        @Override
        public void signal(HistoryEvent signalEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionSignaled(signalEvent);
        }

        @Override
        public void cancel(HistoryEvent cancelEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionCancelRequested(cancelEvent);
        }
    }
}

