/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.internal.context.ContextThreadLocal;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.PotentialDeadlockException;
import io.temporal.internal.sync.RunnerLocalInternal;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.sync.WorkflowThreadImpl;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.workflow.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeterministicRunnerImpl
implements DeterministicRunner {
    private static final int ROOT_THREAD_PRIORITY = 0;
    private static final int CALLBACK_THREAD_PRIORITY = 10;
    private static final int WORKFLOW_THREAD_PRIORITY = 20000000;
    static final String WORKFLOW_ROOT_THREAD_NAME = "workflow-root";
    private static final Logger log = LoggerFactory.getLogger(DeterministicRunnerImpl.class);
    private static final ThreadLocal<WorkflowThread> currentThreadThreadLocal = new ThreadLocal();
    private final Lock lock = new ReentrantLock();
    private boolean inRunUntilAllBlocked;
    private final Set<WorkflowThread> threads = new TreeSet<WorkflowThread>((t1, t2) -> Ints.compare((int)t1.getPriority(), (int)t2.getPriority()));
    private final Map<RunnerLocalInternal<?>, Object> runnerLocalMap = new HashMap();
    private final Runnable rootRunnable;
    private final WorkflowThreadExecutor workflowThreadExecutor;
    private final SyncWorkflowContext workflowContext;
    private final WorkflowExecutorCache cache;
    private final List<NamedRunnable> toExecuteInWorkflowThread = new ArrayList<NamedRunnable>();
    private final List<WorkflowThread> workflowThreadsToAdd = new ArrayList<WorkflowThread>();
    private final List<WorkflowThread> callbackThreadsToAdd = new ArrayList<WorkflowThread>();
    private int addedThreads;
    private boolean exitRequested;
    private boolean closeRequested;
    private boolean closeStarted;
    private final CompletableFuture<?> closeFuture = new CompletableFuture();
    private final Set<Promise<?>> failedPromises = new HashSet();
    private WorkflowThread rootWorkflowThread;
    private final CancellationScopeImpl runnerCancellationScope;

    static WorkflowThread currentThreadInternal() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            throw new Error("Called from non workflow or workflow callback thread");
        }
        return result;
    }

    static Optional<WorkflowThread> currentThreadInternalIfPresent() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    static void setCurrentThreadInternal(WorkflowThread coroutine) {
        if (coroutine != null) {
            currentThreadThreadLocal.set(coroutine);
            WorkflowThreadMarkerAccessor.markAsWorkflowThread();
        } else {
            currentThreadThreadLocal.set(null);
            WorkflowThreadMarkerAccessor.markAsNonWorkflowThread();
        }
    }

    DeterministicRunnerImpl(WorkflowThreadExecutor workflowThreadExecutor, @Nonnull SyncWorkflowContext workflowContext, Runnable root) {
        this(workflowThreadExecutor, workflowContext, root, null);
    }

    DeterministicRunnerImpl(WorkflowThreadExecutor workflowThreadExecutor, @Nonnull SyncWorkflowContext workflowContext, Runnable root, WorkflowExecutorCache cache) {
        this.workflowThreadExecutor = workflowThreadExecutor;
        this.workflowContext = (SyncWorkflowContext)Preconditions.checkNotNull((Object)workflowContext, (Object)"workflowContext");
        this.workflowContext.setRunner(this);
        this.cache = cache;
        this.runnerCancellationScope = new CancellationScopeImpl(true, null, null);
        this.rootRunnable = root;
    }

    @Override
    public void runUntilAllBlocked(long deadlockDetectionTimeout) {
        block16: {
            if (this.rootWorkflowThread == null) {
                this.rootWorkflowThread = this.newRootThread(this.rootRunnable);
                this.threads.add(this.rootWorkflowThread);
                this.rootWorkflowThread.start();
            }
            this.lock.lock();
            try {
                boolean progress;
                this.checkNotClosed();
                this.checkNotCloseRequestedLocked();
                this.inRunUntilAllBlocked = true;
                do {
                    if (this.exitRequested) {
                        this.closeRequested = true;
                        break;
                    }
                    if (!this.toExecuteInWorkflowThread.isEmpty()) {
                        for (NamedRunnable nr : this.toExecuteInWorkflowThread) {
                            Object callbackThread = this.workflowContext.getWorkflowInboundInterceptor().newCallbackThread(nr.runnable, nr.name);
                            Preconditions.checkState((callbackThread != null ? 1 : 0) != 0, (Object)"[BUG] One of the custom interceptors illegally overrode newCallbackThread result to null. Check WorkflowInboundCallsInterceptor#newCallbackThread contract.");
                            Preconditions.checkState((boolean)(callbackThread instanceof WorkflowThread), (String)"[BUG] One of the custom interceptors illegally overrode newCallbackThread result. Check WorkflowInboundCallsInterceptor#newCallbackThread contract. Illegal object returned from the interceptors chain: %s", (Object)callbackThread);
                        }
                        this.appendCallbackThreadsLocked();
                    }
                    this.toExecuteInWorkflowThread.clear();
                    progress = false;
                    Iterator<WorkflowThread> ci = this.threads.iterator();
                    while (ci.hasNext()) {
                        WorkflowThread c = ci.next();
                        boolean bl = progress = c.runUntilBlocked(deadlockDetectionTimeout) || progress;
                        if (this.exitRequested) {
                            this.closeRequested = true;
                            break block16;
                        }
                        if (!c.isDone()) continue;
                        ci.remove();
                        Throwable unhandledException = c.getUnhandledException();
                        if (unhandledException == null) continue;
                        this.closeRequested = true;
                        throw WorkflowInternal.wrap(unhandledException);
                    }
                    this.appendWorkflowThreadsLocked();
                } while (progress && !this.threads.isEmpty());
            }
            catch (PotentialDeadlockException e) {
                String triggerThreadStackTrace = "";
                StringBuilder otherThreadsDump = new StringBuilder();
                for (WorkflowThread t : this.threads) {
                    if (t.getWorkflowThreadContext() != e.getWorkflowThreadContext()) {
                        if (otherThreadsDump.length() > 0) {
                            otherThreadsDump.append("\n");
                        }
                        otherThreadsDump.append(t.getStackTrace());
                        continue;
                    }
                    triggerThreadStackTrace = t.getStackTrace();
                }
                e.setStackDump(triggerThreadStackTrace, otherThreadsDump.toString(), System.currentTimeMillis());
                throw e;
            }
            finally {
                this.inRunUntilAllBlocked = false;
                this.lock.unlock();
                if (this.closeRequested) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.closeFuture.isDone() || !this.closeRequested && !this.areThreadsToBeExecuted();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancel(String reason) {
        this.executeInWorkflowThread("cancel workflow callback", () -> this.rootWorkflowThread.cancel(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        if (this.closeFuture.isDone()) {
            this.lock.unlock();
            return;
        }
        this.closeRequested = true;
        if (this.inRunUntilAllBlocked || this.closeStarted) {
            this.lock.unlock();
            this.closeFuture.join();
            return;
        }
        this.closeStarted = true;
        try {
            while (this.areThreadsToBeExecuted()) {
                ArrayList<WorkflowThreadStopFuture> threadFutures = new ArrayList<WorkflowThreadStopFuture>();
                try {
                    this.toExecuteInWorkflowThread.clear();
                    this.appendWorkflowThreadsLocked();
                    this.appendCallbackThreadsLocked();
                    for (WorkflowThread workflowThread : this.threads) {
                        threadFutures.add(new WorkflowThreadStopFuture(workflowThread, workflowThread.stopNow()));
                    }
                    this.threads.clear();
                    HashSet<Promise<?>> failedPromisesLoop = new HashSet(this.failedPromises);
                    Iterator iterator = failedPromisesLoop.iterator();
                    while (iterator.hasNext()) {
                        Promise f = (Promise)iterator.next();
                        try {
                            f.get();
                            throw new Error("unreachable");
                        }
                        catch (RuntimeException e) {
                            log.warn("Promise completed with exception and was never accessed. The ignored exception:", CheckedExceptionWrapper.unwrap((Throwable)e));
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
                try {
                    for (WorkflowThreadStopFuture workflowThreadStopFuture : threadFutures) {
                        try {
                            workflowThreadStopFuture.stopFuture.get(10L, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException e) {
                            WorkflowThread workflowThread = workflowThreadStopFuture.workflowThread;
                            log.error("[BUG] Workflow thread '{}' of workflow '{}' can't be destroyed in time. This will lead to a workflow cache leak. This problem is usually caused by a workflow implementation swallowing java.lang.Error instead of rethrowing it.  Thread dump of the stuck thread:\n{}", new Object[]{workflowThread.getName(), this.workflowContext.getReplayContext().getWorkflowId(), workflowThread.getStackTrace()});
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new Error("Worker executor thread interrupted during stopping of a coroutine", e);
                }
                catch (ExecutionException e) {
                    throw new Error("[BUG] Unexpected failure while stopping a coroutine", e);
                }
                finally {
                    this.lock.lock();
                }
            }
        }
        finally {
            this.closeFuture.complete(null);
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stackTrace() {
        StringBuilder result = new StringBuilder();
        this.lock.lock();
        try {
            if (this.closeFuture.isDone()) {
                String string = "Workflow is closed.";
                return string;
            }
            for (WorkflowThread coroutine : this.threads) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                coroutine.addStackTrace(result);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result.toString();
    }

    private void appendWorkflowThreadsLocked() {
        this.threads.addAll(this.workflowThreadsToAdd);
        this.workflowThreadsToAdd.clear();
    }

    private void appendCallbackThreadsLocked() {
        for (int i = this.callbackThreadsToAdd.size() - 1; i >= 0; --i) {
            this.threads.add(this.callbackThreadsToAdd.get(i));
        }
        this.callbackThreadsToAdd.clear();
    }

    private WorkflowThread newRootThread(Runnable runnable) {
        String name = WORKFLOW_ROOT_THREAD_NAME;
        if (this.rootWorkflowThread != null) {
            throw new IllegalStateException("newRootThread can be called only if there is no existing root workflow thread");
        }
        this.rootWorkflowThread = new WorkflowThreadImpl(this.workflowThreadExecutor, this.workflowContext, this, name, 0, false, this.runnerCancellationScope, runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        return this.rootWorkflowThread;
    }

    @Override
    @Nonnull
    public WorkflowThread newWorkflowThread(Runnable runnable, boolean detached, @Nullable String name) {
        if (name == null) {
            name = "workflow[" + this.workflowContext.getReplayContext().getWorkflowId() + "]-" + this.addedThreads;
        }
        if (this.rootWorkflowThread == null) {
            throw new IllegalStateException("newChildThread can be called only with existing root workflow thread");
        }
        this.checkWorkflowThreadOnly();
        this.checkNotClosed();
        WorkflowThreadImpl result = new WorkflowThreadImpl(this.workflowThreadExecutor, this.workflowContext, this, name, 20000000 + this.addedThreads++, detached, CancellationScopeImpl.current(), runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        this.workflowThreadsToAdd.add(result);
        return result;
    }

    @Override
    @Nonnull
    public WorkflowThread newCallbackThread(Runnable runnable, @Nullable String name) {
        if (name == null) {
            name = "workflow[" + this.workflowContext.getReplayContext().getWorkflowId() + "]-" + this.addedThreads;
        }
        WorkflowThreadImpl result = new WorkflowThreadImpl(this.workflowThreadExecutor, this.workflowContext, this, name, 10 + this.addedThreads++, false, this.runnerCancellationScope, runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        this.callbackThreadsToAdd.add(result);
        return result;
    }

    @Override
    public void executeInWorkflowThread(String name, Runnable runnable) {
        this.lock.lock();
        try {
            this.toExecuteInWorkflowThread.add(new NamedRunnable(name, runnable));
        }
        finally {
            this.lock.unlock();
        }
    }

    Lock getLock() {
        return this.lock;
    }

    void registerFailedPromise(Promise<?> promise) {
        if (!promise.isCompleted()) {
            throw new Error("expected failed");
        }
        this.failedPromises.add(promise);
    }

    void forgetFailedPromise(Promise<?> promise) {
        this.failedPromises.remove(promise);
    }

    void exit() {
        this.checkNotClosed();
        this.checkWorkflowThreadOnly();
        this.exitRequested = true;
    }

    private void checkWorkflowThreadOnly() {
        if (!this.inRunUntilAllBlocked) {
            throw new Error("called from non workflow thread");
        }
    }

    private void checkNotCloseRequestedLocked() {
        if (this.closeRequested) {
            throw new Error("close requested");
        }
    }

    private void checkNotClosed() {
        if (this.closeFuture.isDone()) {
            throw new Error("closed");
        }
    }

    private boolean areThreadsToBeExecuted() {
        return !this.threads.isEmpty() || !this.workflowThreadsToAdd.isEmpty() || !this.callbackThreadsToAdd.isEmpty() || !this.toExecuteInWorkflowThread.isEmpty();
    }

    <T> Optional<T> getRunnerLocal(RunnerLocalInternal<T> key) {
        if (!this.runnerLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.runnerLocalMap.get(key));
    }

    <T> void setRunnerLocal(RunnerLocalInternal<T> key, T value) {
        this.runnerLocalMap.put(key, value);
    }

    private Map<String, Object> getPropagatedContexts() {
        if (currentThreadThreadLocal.get() != null) {
            return ContextThreadLocal.getCurrentContextForPropagation();
        }
        return this.workflowContext.getPropagatedContexts();
    }

    private List<ContextPropagator> getContextPropagators() {
        if (currentThreadThreadLocal.get() != null) {
            return ContextThreadLocal.getContextPropagators();
        }
        return this.workflowContext.getContextPropagators();
    }

    private static class WorkflowThreadStopFuture {
        private final WorkflowThread workflowThread;
        private final Future<?> stopFuture;

        public WorkflowThreadStopFuture(WorkflowThread workflowThread, Future<?> stopFuture) {
            this.workflowThread = workflowThread;
            this.stopFuture = stopFuture;
        }
    }

    private static class NamedRunnable {
        private final String name;
        private final Runnable runnable;

        private NamedRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }
    }

    private static class WorkflowThreadMarkerAccessor
    extends WorkflowThreadMarker {
        private WorkflowThreadMarkerAccessor() {
        }

        public static void markAsWorkflowThread() {
            isWorkflowThreadThreadLocal.set(true);
        }

        public static void markAsNonWorkflowThread() {
            isWorkflowThreadThreadLocal.set(false);
        }
    }
}

