/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.WorkflowContext;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.ExecutionInfoStrategy;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowExecuteRunnable;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowMethodThreadNameStrategy;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.worker.WorkflowImplementationOptions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncWorkflow
implements ReplayWorkflow {
    private static final Logger log = LoggerFactory.getLogger(SyncWorkflow.class);
    private final WorkflowThreadExecutor workflowThreadExecutor;
    private final SyncWorkflowDefinition workflow;
    @Nonnull
    private final WorkflowImplementationOptions workflowImplementationOptions;
    private final WorkflowExecutorCache cache;
    private final long defaultDeadlockDetectionTimeout;
    private final WorkflowMethodThreadNameStrategy workflowMethodThreadNameStrategy = ExecutionInfoStrategy.INSTANCE;
    private final SyncWorkflowContext workflowContext;
    private WorkflowExecuteRunnable workflowProc;
    private DeterministicRunner runner;

    public SyncWorkflow(SyncWorkflowDefinition workflow, @Nullable WorkflowImplementationOptions workflowImplementationOptions, DataConverter dataConverter, WorkflowThreadExecutor workflowThreadExecutor, WorkflowExecutorCache cache, List<ContextPropagator> contextPropagators, long defaultDeadlockDetectionTimeout) {
        this.workflow = Objects.requireNonNull(workflow);
        this.workflowImplementationOptions = workflowImplementationOptions == null ? WorkflowImplementationOptions.getDefaultInstance() : workflowImplementationOptions;
        this.workflowThreadExecutor = Objects.requireNonNull(workflowThreadExecutor);
        this.cache = cache;
        this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeout;
        this.workflowContext = new SyncWorkflowContext(workflowImplementationOptions, dataConverter, contextPropagators);
    }

    @Override
    public void start(HistoryEvent event, ReplayWorkflowContext context) {
        if (event.getEventType() != EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED || !event.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalArgumentException("first event is not WorkflowExecutionStarted, but " + event.getEventType());
        }
        WorkflowExecutionStartedEventAttributes startEvent = event.getWorkflowExecutionStartedEventAttributes();
        WorkflowType workflowType = startEvent.getWorkflowType();
        if (this.workflow == null) {
            throw new IllegalArgumentException("Unknown workflow type: " + workflowType);
        }
        this.workflowContext.setReplayContext(context);
        this.workflowProc = new WorkflowExecuteRunnable(this.workflowContext, this.workflow, startEvent, this.workflowImplementationOptions);
        this.runner = DeterministicRunner.newRunner(this.workflowThreadExecutor, this.workflowContext, () -> {
            this.workflow.initialize();
            WorkflowInternal.newWorkflowMethodThread(() -> this.workflowProc.run(), this.workflowMethodThreadNameStrategy.createThreadName(context.getWorkflowExecution())).start();
        }, this.cache);
    }

    @Override
    public void handleSignal(String signalName, Optional<Payloads> input, long eventId) {
        this.runner.executeInWorkflowThread("signal " + signalName, () -> this.workflowProc.handleSignal(signalName, input, eventId));
    }

    @Override
    public boolean eventLoop() {
        if (this.runner == null) {
            return false;
        }
        this.runner.runUntilAllBlocked(this.defaultDeadlockDetectionTimeout);
        return this.runner.isDone() || this.workflowProc.isDone();
    }

    @Override
    public Optional<Payloads> getOutput() {
        return this.workflowProc.getOutput();
    }

    @Override
    public void cancel(String reason) {
        this.runner.cancel(reason);
    }

    @Override
    public void close() {
        if (this.runner != null) {
            this.runner.close();
        }
    }

    @Override
    public Optional<Payloads> query(WorkflowQuery query) {
        if ("__replay_only".equals(query.getQueryType())) {
            return Optional.empty();
        }
        if ("__stack_trace".equals(query.getQueryType())) {
            return DefaultDataConverter.STANDARD_INSTANCE.toPayloads(this.runner.stackTrace());
        }
        Optional<Payloads> args = query.hasQueryArgs() ? Optional.of(query.getQueryArgs()) : Optional.empty();
        return this.workflowProc.handleQuery(query.getQueryType(), args);
    }

    @Override
    public WorkflowContext getWorkflowContext() {
        return this.workflowContext;
    }
}

