/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.temporal.internal.common.DebugModeUtils;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.PotentialDeadlockException;
import io.temporal.internal.sync.Status;
import io.temporal.workflow.Functions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkflowThreadContext {
    private static final Logger log = LoggerFactory.getLogger(WorkflowThreadContext.class);
    private final Lock lock;
    private final Condition yieldCondition;
    private final Condition runCondition;
    private final Condition evaluationCondition;
    private Status status = Status.CREATED;
    @Nullable
    private Thread currentThread;
    private Functions.Proc1<String> evaluationFunction;
    private Throwable unhandledException;
    private boolean inRunUntilBlocked;
    private boolean remainedBlocked;
    private String yieldReason;
    private boolean destroyRequested;

    WorkflowThreadContext(Lock lock) {
        this.lock = lock;
        this.yieldCondition = lock.newCondition();
        this.runCondition = lock.newCondition();
        this.evaluationCondition = lock.newCondition();
    }

    public void initialYield() {
        Status status = this.getStatus();
        if (status == Status.DONE) {
            throw new DestroyWorkflowThreadError("done in initialYield");
        }
        Preconditions.checkState((status == Status.RUNNING ? 1 : 0) != 0, (Object)"threadContext not in RUNNING state");
        this.yield("created", () -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void yield(String reason, Supplier<Boolean> unblockFunction) {
        if (unblockFunction == null) {
            throw new IllegalArgumentException("null unblockFunction");
        }
        this.lock.lock();
        try {
            if (this.destroyRequested) {
                throw new DestroyWorkflowThreadError();
            }
            this.yieldReason = reason;
            while (!this.inRunUntilBlocked || !unblockFunction.get().booleanValue()) {
                this.status = Status.YIELDED;
                this.runCondition.signal();
                this.yieldCondition.await();
                if (this.destroyRequested) {
                    throw new DestroyWorkflowThreadError();
                }
                this.maybeEvaluateLocked(reason);
            }
            this.status = Status.RUNNING;
            this.yieldReason = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!this.isDestroyRequested()) {
                throw new Error("Unexpected interrupt", e);
            }
        }
        finally {
            this.remainedBlocked = false;
            this.lock.unlock();
        }
    }

    private void maybeEvaluateLocked(String reason) {
        if (this.status == Status.EVALUATING) {
            try {
                this.evaluationFunction.apply(reason);
            }
            catch (Exception e) {
                this.evaluationFunction.apply(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.status = Status.RUNNING;
                this.evaluationCondition.signal();
            }
        }
    }

    public void evaluateInCoroutineContext(Functions.Proc1<String> function) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"null function");
            if (this.status != Status.YIELDED && this.status != Status.RUNNING) {
                throw new IllegalStateException("Not in yielded status: " + (Object)((Object)this.status));
            }
            if (this.evaluationFunction != null) {
                throw new IllegalStateException("Already evaluating");
            }
            Preconditions.checkState((!this.inRunUntilBlocked ? 1 : 0) != 0, (Object)"Running runUntilBlocked");
            this.evaluationFunction = function;
            this.status = Status.EVALUATING;
            this.yieldCondition.signal();
            while (this.status == Status.EVALUATING) {
                this.evaluationCondition.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Error("Unexpected interrupt", e);
        }
        finally {
            this.evaluationFunction = null;
            this.lock.unlock();
        }
    }

    public void verifyAndStart() {
        this.lock.lock();
        try {
            Preconditions.checkState((this.status == Status.CREATED ? 1 : 0) != 0, (Object)"already started");
            this.status = Status.RUNNING;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Status getStatus() {
        this.lock.lock();
        try {
            Status status = this.status;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setStatus(Status status) {
        this.lock.lock();
        try {
            this.status = status;
            if (this.isDone()) {
                this.runCondition.signal();
                this.clearCurrentThreadLocked();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.status == Status.DONE;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Throwable getUnhandledException() {
        this.lock.lock();
        try {
            Throwable throwable = this.unhandledException;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUnhandledException(Throwable unhandledException) {
        this.lock.lock();
        try {
            this.unhandledException = unhandledException;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getYieldReason() {
        return this.yieldReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runUntilBlocked(long deadlockDetectionTimeoutMs) {
        if (DebugModeUtils.isTemporalDebugModeOn()) {
            deadlockDetectionTimeoutMs = Long.MAX_VALUE;
        }
        this.lock.lock();
        try {
            boolean awaitTimedOut;
            if (this.status == Status.DONE) {
                boolean bl = false;
                return bl;
            }
            Preconditions.checkState((this.evaluationFunction == null ? 1 : 0) != 0, (Object)"Cannot runUntilBlocked while evaluating");
            this.inRunUntilBlocked = true;
            if (this.status == Status.YIELDED) {
                this.status = Status.RUNNING;
            }
            this.remainedBlocked = true;
            this.yieldCondition.signal();
            while (this.potentialProgressStatesLocked()) {
                boolean bl = awaitTimedOut = !this.runCondition.await(deadlockDetectionTimeoutMs, TimeUnit.MILLISECONDS);
                if (awaitTimedOut && this.potentialProgressStatesLocked()) {
                    long detectionTimestamp = System.currentTimeMillis();
                    if (this.currentThread != null) {
                        throw new PotentialDeadlockException(this.currentThread.getName(), this, detectionTimestamp);
                    }
                    log.warn("Illegal State: WorkflowThreadContext has no currentThread in {} state", (Object)this.status);
                    throw new PotentialDeadlockException("UnknownThread", this, detectionTimestamp);
                }
                Preconditions.checkState((this.evaluationFunction == null ? 1 : 0) != 0, (Object)"Cannot runUntilBlocked while evaluating");
            }
            awaitTimedOut = !this.remainedBlocked;
            return awaitTimedOut;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!this.isDestroyRequested()) {
                throw new Error("Unexpected interrupt", e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.inRunUntilBlocked = false;
            this.lock.unlock();
        }
    }

    private boolean potentialProgressStatesLocked() {
        return this.status == Status.RUNNING || this.status == Status.CREATED;
    }

    public boolean isDestroyRequested() {
        this.lock.lock();
        try {
            boolean bl = this.destroyRequested;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void initiateDestroy() {
        this.lock.lock();
        try {
            this.destroyRequested = true;
            if (this.status == Status.CREATED) {
                this.status = Status.DONE;
                return;
            }
            if (this.status == Status.RUNNING) {
                return;
            }
            if (this.status == Status.DONE) {
                return;
            }
            this.yieldCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initializeCurrentThread(Thread currentThread) {
        this.lock.lock();
        try {
            this.currentThread = currentThread;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearCurrentThreadLocked() {
        this.currentThread = null;
    }

    @Nullable
    public Thread getCurrentThread() {
        this.lock.lock();
        try {
            Thread thread = this.currentThread;
            return thread;
        }
        finally {
            this.lock.unlock();
        }
    }
}

