/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.DoubleValue;
import com.uber.m3.tally.Scope;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.taskqueue.v1.TaskQueueMetadata;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.Poller;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityPollTask
implements Poller.PollTask<ActivityTask> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPollTask.class);
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final String identity;
    private final double activitiesPerSecond;
    private final Semaphore pollSemaphore;
    private final Scope metricsScope;

    public ActivityPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, double activitiesPerSecond, Semaphore pollSemaphore, @Nonnull Scope metricsScope) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.identity = Objects.requireNonNull(identity);
        this.activitiesPerSecond = activitiesPerSecond;
        this.pollSemaphore = pollSemaphore;
        this.metricsScope = Objects.requireNonNull(metricsScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTask poll() {
        PollActivityTaskQueueRequest.Builder pollRequest = PollActivityTaskQueueRequest.newBuilder().setNamespace(this.namespace).setIdentity(this.identity).setTaskQueue(TaskQueue.newBuilder().setName(this.taskQueue));
        if (this.activitiesPerSecond > 0.0) {
            pollRequest.setTaskQueueMetadata(TaskQueueMetadata.newBuilder().setMaxTasksPerSecond(DoubleValue.newBuilder().setValue(this.activitiesPerSecond).build()).build());
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + pollRequest);
        }
        boolean isSuccessful = false;
        try {
            this.pollSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            PollActivityTaskQueueResponse response = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollActivityTaskQueue(pollRequest.build());
            if (response == null || response.getTaskToken().isEmpty()) {
                this.metricsScope.counter("temporal_activity_poll_no_task").inc(1L);
                ActivityTask activityTask = null;
                return activityTask;
            }
            this.metricsScope.timer("temporal_activity_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(response.getStartedTime(), response.getCurrentAttemptScheduledTime()));
            isSuccessful = true;
            ActivityTask activityTask = new ActivityTask(response, this.pollSemaphore::release);
            return activityTask;
        }
        finally {
            if (!isSuccessful) {
                this.pollSemaphore.release();
            }
        }
    }
}

