/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.LocalActivityTask;
import io.temporal.internal.worker.Poller;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalActivityPollTask
implements Poller.PollTask<LocalActivityTask>,
BiFunction<LocalActivityTask, Duration, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(LocalActivityPollTask.class);
    private static final int QUEUE_SIZE = 1000;
    private final BlockingQueue<LocalActivityTask> pendingTasks = new ArrayBlockingQueue<LocalActivityTask>(1000);

    LocalActivityPollTask() {
    }

    @Override
    public LocalActivityTask poll() {
        try {
            LocalActivityTask task = this.pendingTasks.take();
            log.trace("LocalActivity Task poll returned: {}", (Object)task.getActivityId());
            return task;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public Boolean apply(LocalActivityTask task, Duration maxWaitAllowed) {
        try {
            boolean accepted = this.pendingTasks.offer(task, maxWaitAllowed.toMillis(), TimeUnit.MILLISECONDS);
            if (accepted) {
                log.trace("LocalActivity queued: {}", (Object)task.getActivityId());
            } else {
                log.trace("LocalActivity queue submitting timed out for activity {}, maxWaitAllowed: {}", (Object)task.getActivityId(), (Object)maxWaitAllowed);
            }
            return accepted;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

