/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.Shutdownable;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ShutdownManager.class);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory("TemporalShutdownManager", null));
    private static final int CHECK_PERIOD_MS = 250;

    public CompletableFuture<Void> shutdownExecutorNow(ExecutorService executorToShutdown, String executorName, Duration timeout) {
        executorToShutdown.shutdownNow();
        return this.limitedWait(executorToShutdown, executorName, timeout);
    }

    public CompletableFuture<Void> shutdownExecutorNowUntimed(ExecutorService executorToShutdown, String executorName) {
        executorToShutdown.shutdownNow();
        return this.untimedWait(executorToShutdown, executorName);
    }

    public CompletableFuture<Void> shutdownExecutor(ExecutorService executorToShutdown, String executorName, Duration timeout) {
        executorToShutdown.shutdown();
        return this.limitedWait(executorToShutdown, executorName, timeout);
    }

    public CompletableFuture<Void> shutdownExecutorUntimed(ExecutorService executorToShutdown, String executorName) {
        executorToShutdown.shutdown();
        return this.untimedWait(executorToShutdown, executorName);
    }

    private CompletableFuture<Void> untimedWait(ExecutorService executorToShutdown, String executorName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduledExecutorService.submit(new ReportingDelayShutdown(executorToShutdown, executorName, future));
        return future;
    }

    private CompletableFuture<Void> limitedWait(ExecutorService executorToShutdown, String executorName, Duration timeout) {
        int attempts = (int)Math.ceil((double)timeout.toMillis() / 250.0);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduledExecutorService.submit(new LimitedWaitShutdown(executorToShutdown, attempts, executorName, future));
        return future;
    }

    @Override
    public void close() {
        this.scheduledExecutorService.shutdownNow();
    }

    public static long awaitTermination(@Nullable ExecutorService s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return ShutdownManager.runAndGetRemainingTimeoutMs(timeoutMillis, () -> {
            try {
                s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public static long runAndGetRemainingTimeoutMs(long initialTimeoutMs, Runnable toRun) {
        long startedNs = System.nanoTime();
        try {
            toRun.run();
        }
        catch (Throwable e) {
            log.warn("Exception during waiting for termination", e);
        }
        long remainingTimeoutMs = initialTimeoutMs - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedNs);
        return remainingTimeoutMs < 0L ? 0L : remainingTimeoutMs;
    }

    public static long awaitTermination(@Nullable Shutdownable s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return ShutdownManager.runAndGetRemainingTimeoutMs(timeoutMillis, () -> s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    private class ReportingDelayShutdown
    implements Runnable {
        private static final int BLOCKED_REPORTING_THRESHOLD = 60;
        private static final int BLOCKED_REPORTING_PERIOD = 20;
        private final ExecutorService executorToShutdown;
        private final CompletableFuture<Void> promise;
        private final String executorName;
        private int attempt;

        public ReportingDelayShutdown(ExecutorService executorToShutdown, String executorName, CompletableFuture<Void> promise) {
            this.executorToShutdown = executorToShutdown;
            this.promise = promise;
            this.executorName = executorName;
        }

        @Override
        public void run() {
            if (this.executorToShutdown.isTerminated()) {
                if (this.attempt > 60) {
                    log.warn("{} successfully terminated", (Object)this.executorName);
                }
                this.promise.complete(null);
                return;
            }
            ++this.attempt;
            if (this.attempt >= 60 && (double)((float)(this.attempt - 60) % 20.0f) < 0.001) {
                log.warn("Graceful shutdown of {} is blocked by one of the long currently processing tasks", (Object)this.executorName);
            }
            ShutdownManager.this.scheduledExecutorService.schedule(this, 250L, TimeUnit.MILLISECONDS);
        }
    }

    private class LimitedWaitShutdown
    implements Runnable {
        private final ExecutorService executorToShutdown;
        private final CompletableFuture<Void> promise;
        private final int maxAttempts;
        private final String executorName;
        private int attempt;

        public LimitedWaitShutdown(ExecutorService executorToShutdown, int maxAttempts, String executorName, CompletableFuture<Void> promise) {
            this.executorToShutdown = executorToShutdown;
            this.promise = promise;
            this.maxAttempts = maxAttempts;
            this.executorName = executorName;
        }

        @Override
        public void run() {
            if (this.executorToShutdown.isTerminated()) {
                this.promise.complete(null);
                return;
            }
            ++this.attempt;
            if (this.attempt > this.maxAttempts) {
                log.warn("Wait for a graceful shutdown of {} timed out, fallback to shutdownNow()", (Object)this.executorName);
                this.executorToShutdown.shutdownNow();
                this.promise.complete(null);
                return;
            }
            ShutdownManager.this.scheduledExecutorService.schedule(this, 250L, TimeUnit.MILLISECONDS);
        }
    }
}

