/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.payload.codec;

import io.temporal.api.common.v1.Payload;
import io.temporal.payload.codec.PayloadCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;

public class ChainCodec
implements PayloadCodec {
    private final List<PayloadCodec> codecs;

    public ChainCodec(Collection<PayloadCodec> codecs) {
        this.codecs = new ArrayList<PayloadCodec>(codecs);
    }

    @Override
    @Nonnull
    public List<Payload> encode(@Nonnull List<Payload> payloads) {
        ListIterator<PayloadCodec> iterator = this.codecs.listIterator(this.codecs.size());
        while (iterator.hasPrevious()) {
            PayloadCodec codec = iterator.previous();
            payloads = codec.encode(payloads);
        }
        return payloads;
    }

    @Override
    @Nonnull
    public List<Payload> decode(@Nonnull List<Payload> payloads) {
        for (PayloadCodec codec : this.codecs) {
            payloads = codec.decode(payloads);
        }
        return payloads;
    }
}

