/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.MoreObjects;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.common.SearchAttribute;
import io.temporal.internal.common.SearchAttributePayloadConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchAttributesUtil {
    private static final SearchAttributePayloadConverter converter = SearchAttributePayloadConverter.INSTANCE;

    @Nonnull
    public static SearchAttributes encode(@Nonnull Map<String, ?> searchAttributes) {
        SearchAttributes.Builder builder = SearchAttributes.newBuilder();
        searchAttributes.forEach((key, value) -> builder.putIndexedFields(key, converter.encode(MoreObjects.firstNonNull((Object)value, SearchAttribute.UNSET_VALUE))));
        return builder.build();
    }

    @Nonnull
    public static Map<String, List<?>> decode(@Nonnull SearchAttributes searchAttributes) {
        if (SearchAttributesUtil.isEmpty(searchAttributes)) {
            return Collections.emptyMap();
        }
        Map searchAttributesMap = searchAttributes.getIndexedFieldsMap();
        HashMap deserializedMap = new HashMap(searchAttributesMap.size() * 4 / 3);
        searchAttributesMap.forEach((key, payload) -> {
            List<?> data = converter.decode((Payload)payload);
            if (data.size() > 0) {
                deserializedMap.put((String)key, data);
            }
        });
        return deserializedMap;
    }

    @Nullable
    public static <T> List<T> decode(@Nonnull SearchAttributes searchAttributes, @Nonnull String attributeName) {
        if (SearchAttributesUtil.isEmpty(searchAttributes) || !searchAttributes.containsIndexedFields(attributeName)) {
            return null;
        }
        Payload payload = searchAttributes.getIndexedFieldsOrThrow(attributeName);
        List<?> data = converter.decode(payload);
        if (data.size() == 0) {
            return null;
        }
        return data;
    }

    @Nullable
    public static <T> List<T> decodeAsType(@Nonnull SearchAttributes searchAttributes, @Nonnull String attributeName, @Nonnull IndexedValueType indexType) {
        if (SearchAttributesUtil.isEmpty(searchAttributes) || !searchAttributes.containsIndexedFields(attributeName)) {
            return null;
        }
        Payload payload = searchAttributes.getIndexedFieldsOrThrow(attributeName);
        List<?> data = converter.decodeAsType(payload, indexType);
        if (data.size() == 0) {
            return null;
        }
        return data;
    }

    private static boolean isEmpty(SearchAttributes searchAttributes) {
        return searchAttributes.getIndexedFieldsCount() == 0;
    }
}

