/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.env.ReflectionUtils;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowFactory;
import io.temporal.internal.sync.BaseRootWorkflowInboundCallsInterceptor;
import io.temporal.internal.sync.DynamicSyncWorkflowDefinition;
import io.temporal.internal.sync.QueryDispatcher;
import io.temporal.internal.sync.SignalDispatcher;
import io.temporal.internal.sync.SyncWorkflow;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.payload.context.WorkflowSerializationContext;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.worker.TypeAlreadyRegisteredException;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.DynamicWorkflow;
import io.temporal.workflow.Functions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POJOWorkflowImplementationFactory
implements ReplayWorkflowFactory {
    private static final Logger log = LoggerFactory.getLogger(POJOWorkflowImplementationFactory.class);
    public static final ImmutableSet<String> WORKFLOW_HANDLER_STACKTRACE_CUTOFF = ImmutableSet.builder().add((Object)ReflectionUtils.getMethodNameForStackTraceCutoff(POJOWorkflowImplementation.class, "execute", Header.class, Optional.class)).add((Object)ReflectionUtils.getMethodNameForStackTraceCutoff(DynamicSyncWorkflowDefinition.class, "execute", Header.class, Optional.class)).build();
    private final WorkerInterceptor[] workerInterceptors;
    private final DataConverter dataConverter;
    private final List<ContextPropagator> contextPropagators;
    private final long defaultDeadlockDetectionTimeout;
    private final Map<String, Functions.Func1<WorkflowExecution, SyncWorkflowDefinition>> workflowDefinitions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Functions.Func<?>> workflowInstanceFactories = Collections.synchronizedMap(new HashMap());
    private Functions.Func<? extends DynamicWorkflow> dynamicWorkflowImplementationFactory;
    private final Map<String, WorkflowImplementationOptions> implementationOptions = Collections.synchronizedMap(new HashMap());
    private final WorkflowThreadExecutor workflowThreadExecutor;
    private final WorkflowExecutorCache cache;
    private final String namespace;

    public POJOWorkflowImplementationFactory(SingleWorkerOptions singleWorkerOptions, WorkflowThreadExecutor workflowThreadExecutor, WorkerInterceptor[] workerInterceptors, WorkflowExecutorCache cache, @Nonnull String namespace) {
        Objects.requireNonNull(singleWorkerOptions);
        this.dataConverter = singleWorkerOptions.getDataConverter();
        this.workflowThreadExecutor = Objects.requireNonNull(workflowThreadExecutor);
        this.workerInterceptors = Objects.requireNonNull(workerInterceptors);
        this.cache = cache;
        this.contextPropagators = singleWorkerOptions.getContextPropagators();
        this.defaultDeadlockDetectionTimeout = singleWorkerOptions.getDefaultDeadlockDetectionTimeout();
        this.namespace = namespace;
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        for (Class<?> type : workflowImplementationTypes) {
            this.registerWorkflowImplementationType(options, type);
        }
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        if (DynamicWorkflow.class.isAssignableFrom(clazz)) {
            if (this.dynamicWorkflowImplementationFactory != null) {
                throw new TypeAlreadyRegisteredException("DynamicWorkflow", "An implementation of DynamicWorkflow or its factory is already registered with the worker");
            }
            this.dynamicWorkflowImplementationFactory = factory;
            return;
        }
        this.workflowInstanceFactories.put(clazz, factory);
        POJOWorkflowInterfaceMetadata workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(clazz);
        if (!workflowMetadata.getWorkflowMethod().isPresent()) {
            throw new IllegalArgumentException("Workflow interface doesn't contain a method annotated with @WorkflowMethod: " + clazz);
        }
        List<POJOWorkflowMethodMetadata> methodsMetadata = workflowMetadata.getMethodsMetadata();
        for (POJOWorkflowMethodMetadata methodMetadata : methodsMetadata) {
            switch (methodMetadata.getType()) {
                case WORKFLOW: {
                    String typeName = methodMetadata.getName();
                    if (this.workflowDefinitions.containsKey(typeName)) {
                        throw new TypeAlreadyRegisteredException(typeName, "\"" + typeName + "\" workflow type is already registered with the worker");
                    }
                    this.workflowDefinitions.put(typeName, execution -> new POJOWorkflowImplementation(clazz, methodMetadata.getWorkflowMethod(), this.dataConverter.withContext(new WorkflowSerializationContext(this.namespace, execution.getWorkflowId()))));
                    this.implementationOptions.put(typeName, options);
                    break;
                }
            }
        }
    }

    private <T> void registerWorkflowImplementationType(WorkflowImplementationOptions options, Class<T> workflowImplementationClass) {
        if (DynamicWorkflow.class.isAssignableFrom(workflowImplementationClass)) {
            this.addWorkflowImplementationFactory(options, workflowImplementationClass, () -> {
                try {
                    return workflowImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new Error("Failure instantiating workflow implementation class " + workflowImplementationClass.getName(), e);
                }
            });
            return;
        }
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newInstance(workflowImplementationClass);
        List<POJOWorkflowMethodMetadata> workflowMethods = workflowMetadata.getWorkflowMethods();
        if (workflowMethods.isEmpty()) {
            throw new IllegalArgumentException("Workflow implementation doesn't implement any interface with a workflow method annotated with @WorkflowMethod: " + workflowImplementationClass);
        }
        for (POJOWorkflowMethodMetadata workflowMethod : workflowMethods) {
            String workflowName = workflowMethod.getName();
            Method method = workflowMethod.getWorkflowMethod();
            Functions.Func1<WorkflowExecution, SyncWorkflowDefinition> definition = execution -> new POJOWorkflowImplementation(workflowImplementationClass, method, this.dataConverter.withContext(new WorkflowSerializationContext(this.namespace, execution.getWorkflowId())));
            if (this.workflowDefinitions.containsKey(workflowName)) {
                throw new IllegalStateException(workflowName + " workflow type is already registered with the worker");
            }
            this.workflowDefinitions.put(workflowName, definition);
            this.implementationOptions.put(workflowName, options);
        }
    }

    private SyncWorkflowDefinition getWorkflowDefinition(WorkflowType workflowType, WorkflowExecution workflowExecution) {
        Functions.Func1<WorkflowExecution, SyncWorkflowDefinition> factory = this.workflowDefinitions.get(workflowType.getName());
        if (factory == null) {
            if (this.dynamicWorkflowImplementationFactory != null) {
                return new DynamicSyncWorkflowDefinition(this.dynamicWorkflowImplementationFactory, this.workerInterceptors, this.dataConverter);
            }
            throw new Error("Unknown workflow type \"" + workflowType.getName() + "\". Known types are " + this.workflowDefinitions.keySet());
        }
        try {
            return factory.apply(workflowExecution);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public ReplayWorkflow getWorkflow(WorkflowType workflowType, WorkflowExecution workflowExecution) {
        SyncWorkflowDefinition workflow = this.getWorkflowDefinition(workflowType, workflowExecution);
        WorkflowImplementationOptions workflowImplementationOptions = this.implementationOptions.get(workflowType.getName());
        DataConverter dataConverterWithWorkflowContext = this.dataConverter.withContext(new WorkflowSerializationContext(this.namespace, workflowExecution.getWorkflowId()));
        return new SyncWorkflow(this.namespace, workflowExecution, workflow, new SignalDispatcher(dataConverterWithWorkflowContext), new QueryDispatcher(dataConverterWithWorkflowContext), workflowImplementationOptions, this.dataConverter, this.workflowThreadExecutor, this.cache, this.contextPropagators, this.defaultDeadlockDetectionTimeout);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.workflowDefinitions.isEmpty() || this.dynamicWorkflowImplementationFactory != null;
    }

    public String toString() {
        return "POJOWorkflowImplementationFactory{registeredWorkflowTypes=" + this.workflowDefinitions.keySet() + '}';
    }

    private class POJOWorkflowImplementation
    implements SyncWorkflowDefinition {
        private final Class<?> workflowImplementationClass;
        private final Method workflowMethod;
        private WorkflowInboundCallsInterceptor workflowInvoker;
        private final DataConverter dataConverterWithWorkflowContext;

        public POJOWorkflowImplementation(Class<?> workflowImplementationClass, Method workflowMethod, DataConverter dataConverterWithWorkflowContext) {
            this.workflowImplementationClass = workflowImplementationClass;
            this.workflowMethod = workflowMethod;
            this.dataConverterWithWorkflowContext = dataConverterWithWorkflowContext;
        }

        @Override
        public void initialize() {
            SyncWorkflowContext workflowContext = WorkflowInternal.getRootWorkflowContext();
            this.workflowInvoker = new RootWorkflowInboundCallsInterceptor(workflowContext);
            for (WorkerInterceptor workerInterceptor : POJOWorkflowImplementationFactory.this.workerInterceptors) {
                this.workflowInvoker = workerInterceptor.interceptWorkflow(this.workflowInvoker);
            }
            workflowContext.initHeadInboundCallsInterceptor(this.workflowInvoker);
            this.workflowInvoker.init(workflowContext);
        }

        @Override
        public Optional<Payloads> execute(Header header, Optional<Payloads> input) throws CanceledFailure, WorkflowExecutionException {
            Object[] args = DataConverter.arrayFromPayloads(this.dataConverterWithWorkflowContext, input, this.workflowMethod.getParameterTypes(), this.workflowMethod.getGenericParameterTypes());
            Preconditions.checkNotNull((Object)this.workflowInvoker, (Object)"initialize not called");
            WorkflowInboundCallsInterceptor.WorkflowOutput result = this.workflowInvoker.execute(new WorkflowInboundCallsInterceptor.WorkflowInput(header, args));
            if (this.workflowMethod.getReturnType() == Void.TYPE) {
                return Optional.empty();
            }
            return this.dataConverterWithWorkflowContext.toPayloads(result.getResult());
        }

        private class RootWorkflowInboundCallsInterceptor
        extends BaseRootWorkflowInboundCallsInterceptor {
            private Object workflow;

            public RootWorkflowInboundCallsInterceptor(SyncWorkflowContext workflowContext) {
                super(workflowContext);
            }

            @Override
            public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
                super.init(outboundCalls);
                this.newInstance();
                WorkflowInternal.registerListener(this.workflow);
            }

            @Override
            public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
                try {
                    Object result = POJOWorkflowImplementation.this.workflowMethod.invoke(this.workflow, input.getArguments());
                    return new WorkflowInboundCallsInterceptor.WorkflowOutput(result);
                }
                catch (IllegalAccessException e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    throw CheckedExceptionWrapper.wrap((Throwable)target);
                }
            }

            protected void newInstance() {
                Functions.Func factory = (Functions.Func)POJOWorkflowImplementationFactory.this.workflowInstanceFactories.get(POJOWorkflowImplementation.this.workflowImplementationClass);
                if (factory != null) {
                    this.workflow = factory.apply();
                } else {
                    try {
                        this.workflow = POJOWorkflowImplementation.this.workflowImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new Error("Failure instantiating workflow implementation class " + POJOWorkflowImplementation.this.workflowImplementationClass.getName(), e);
                    }
                }
            }
        }
    }
}

