/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.workflow.WorkflowInfo;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;

final class WorkflowInfoImpl
implements WorkflowInfo {
    private final ReplayWorkflowContext context;

    WorkflowInfoImpl(ReplayWorkflowContext context) {
        this.context = context;
    }

    @Override
    public String getNamespace() {
        return this.context.getNamespace();
    }

    @Override
    public String getWorkflowId() {
        return this.context.getWorkflowId();
    }

    @Override
    public String getWorkflowType() {
        return this.context.getWorkflowType().getName();
    }

    @Override
    public String getRunId() {
        return this.context.getRunId();
    }

    @Override
    public String getFirstExecutionRunId() {
        return this.context.getFirstExecutionRunId();
    }

    @Override
    public Optional<String> getContinuedExecutionRunId() {
        return this.context.getContinuedExecutionRunId();
    }

    @Override
    public Optional<String> getOriginalExecutionRunId() {
        return this.context.getOriginalExecutionRunId();
    }

    @Override
    public String getTaskQueue() {
        return this.context.getTaskQueue();
    }

    @Override
    public Duration getWorkflowRunTimeout() {
        return this.context.getWorkflowRunTimeout();
    }

    @Override
    public Duration getWorkflowExecutionTimeout() {
        return this.context.getWorkflowExecutionTimeout();
    }

    @Override
    public long getRunStartedTimestampMillis() {
        return this.context.getRunStartedTimestampMillis();
    }

    @Override
    @Nullable
    public SearchAttributes getSearchAttributes() {
        return this.context.getSearchAttributes();
    }

    @Override
    public Optional<String> getParentWorkflowId() {
        WorkflowExecution parentWorkflowExecution = this.context.getParentWorkflowExecution();
        return parentWorkflowExecution == null ? Optional.empty() : Optional.of(parentWorkflowExecution.getWorkflowId());
    }

    @Override
    public Optional<String> getParentRunId() {
        WorkflowExecution parentWorkflowExecution = this.context.getParentWorkflowExecution();
        return parentWorkflowExecution == null ? Optional.empty() : Optional.of(parentWorkflowExecution.getRunId());
    }

    @Override
    public int getAttempt() {
        return this.context.getAttempt();
    }

    @Override
    public String getCronSchedule() {
        return this.context.getCronSchedule();
    }

    @Override
    public long getHistoryLength() {
        return this.context.getCurrentWorkflowTaskStartedEventId();
    }

    public String toString() {
        return "WorkflowInfo{namespace=" + this.getNamespace() + ", workflowId=" + this.getWorkflowId() + ", runId=" + this.getRunId() + ", workflowType=" + this.getWorkflowType() + ", continuedExecutionRunId=" + this.getContinuedExecutionRunId() + ", taskQueue='" + this.getTaskQueue() + '\'' + ", workflowRunTimeout=" + this.getWorkflowRunTimeout() + ", workflowExecutionTimeout=" + this.getWorkflowExecutionTimeout() + ", runStartedTimestampMillis=" + this.getRunStartedTimestampMillis() + ", searchAttributes=" + this.getSearchAttributes() + ", parentWorkflowId=" + this.getParentWorkflowId() + ", parentRunId=" + this.getParentRunId() + ", attempt=" + this.getAttempt() + ", cronSchedule=" + this.getCronSchedule() + ", historyLength=" + this.getHistoryLength() + '}';
    }
}

