/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.StickyQueueBalancer;
import io.temporal.internal.worker.WorkflowTask;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowPollTask
implements Poller.PollTask<WorkflowTask> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPollTask.class);
    private final Semaphore workflowTaskExecutorSemaphore;
    private final StickyQueueBalancer stickyQueueBalancer;
    private final Scope metricsScope;
    private final Scope stickyMetricsScope;
    private final WorkflowServiceGrpc.WorkflowServiceBlockingStub serviceStub;
    private final PollWorkflowTaskQueueRequest pollRequest;
    private final PollWorkflowTaskQueueRequest stickyPollRequest;

    public WorkflowPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nullable String stickyTaskQueue, @Nonnull String identity, @Nullable String binaryChecksum, @Nonnull Semaphore workflowTaskExecutorSemaphore, @Nonnull StickyQueueBalancer stickyQueueBalancer, @Nonnull Scope workerMetricsScope) {
        this.workflowTaskExecutorSemaphore = Objects.requireNonNull(workflowTaskExecutorSemaphore);
        this.stickyQueueBalancer = Objects.requireNonNull(stickyQueueBalancer);
        this.metricsScope = Objects.requireNonNull(workerMetricsScope);
        this.stickyMetricsScope = workerMetricsScope.tagged((Map)new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)String.format("%s:%s", taskQueue, "sticky")).build());
        this.serviceStub = (WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)Objects.requireNonNull(service).blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope);
        PollWorkflowTaskQueueRequest.Builder pollRequestBuilder = PollWorkflowTaskQueueRequest.newBuilder().setNamespace(Objects.requireNonNull(namespace)).setIdentity(Objects.requireNonNull(identity)).setBinaryChecksum(binaryChecksum);
        this.pollRequest = pollRequestBuilder.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue).setKind(TaskQueueKind.TASK_QUEUE_KIND_NORMAL).build()).build();
        this.stickyPollRequest = pollRequestBuilder.setTaskQueue(TaskQueue.newBuilder().setName(stickyTaskQueue).setKind(TaskQueueKind.TASK_QUEUE_KIND_STICKY).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTask poll() {
        boolean isSuccessful = false;
        try {
            this.workflowTaskExecutorSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        TaskQueueKind taskQueueKind = this.stickyQueueBalancer.makePoll();
        boolean isSticky = TaskQueueKind.TASK_QUEUE_KIND_STICKY.equals((Object)taskQueueKind);
        PollWorkflowTaskQueueRequest request = isSticky ? this.stickyPollRequest : this.pollRequest;
        Scope scope = isSticky ? this.stickyMetricsScope : this.metricsScope;
        log.trace("poll request begin: {}", (Object)request);
        try {
            PollWorkflowTaskQueueResponse response = this.doPoll(request, scope);
            if (response == null) {
                WorkflowTask workflowTask = null;
                return workflowTask;
            }
            isSuccessful = true;
            this.stickyQueueBalancer.finishPoll(taskQueueKind, response.getBacklogCountHint());
            WorkflowTask workflowTask = new WorkflowTask(response, this.workflowTaskExecutorSemaphore::release);
            return workflowTask;
        }
        finally {
            if (!isSuccessful) {
                this.workflowTaskExecutorSemaphore.release();
                this.stickyQueueBalancer.finishPoll(taskQueueKind);
            }
        }
    }

    @Nullable
    private PollWorkflowTaskQueueResponse doPoll(PollWorkflowTaskQueueRequest request, Scope metricsScope) {
        PollWorkflowTaskQueueResponse response = this.serviceStub.pollWorkflowTaskQueue(request);
        if (log.isTraceEnabled()) {
            log.trace("poll request returned workflow task: taskQueue={}, workflowType={}, workflowExecution={}, startedEventId={}, previousStartedEventId={}{}", new Object[]{request.getTaskQueue().getName(), response.getWorkflowType(), response.getWorkflowExecution(), response.getStartedEventId(), response.getPreviousStartedEventId(), response.hasQuery() ? ", queryType=" + response.getQuery().getQueryType() : ""});
        }
        if (response == null || response.getTaskToken().isEmpty()) {
            metricsScope.counter("temporal_workflow_task_queue_poll_empty").inc(1L);
            return null;
        }
        metricsScope.counter("temporal_workflow_task_queue_poll_succeed").inc(1L);
        metricsScope.timer("temporal_workflow_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(response.getStartedTime(), response.getScheduledTime()));
        return response;
    }
}

