/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.client.WorkflowOptions;
import io.temporal.client.schedules.ScheduleAction;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.Header;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;

public final class ScheduleActionStartWorkflow
extends ScheduleAction {
    private final String workflowType;
    private final WorkflowOptions options;
    private final Header header;
    private final EncodedValues arguments;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ScheduleActionStartWorkflow options) {
        return new Builder(options);
    }

    private ScheduleActionStartWorkflow(String workflowType, WorkflowOptions options, Header header, EncodedValues arguments) {
        this.workflowType = workflowType;
        this.options = options;
        this.header = header;
        this.arguments = arguments;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public WorkflowOptions getOptions() {
        return this.options;
    }

    public Header getHeader() {
        return this.header;
    }

    public EncodedValues getArguments() {
        return this.arguments;
    }

    public static class Builder {
        private String workflowType;
        private WorkflowOptions options;
        private Header header;
        private EncodedValues arguments;

        private Builder() {
        }

        private Builder(ScheduleActionStartWorkflow options) {
            if (options == null) {
                return;
            }
            this.workflowType = options.workflowType;
            this.options = options.options;
            this.header = options.header;
            this.arguments = options.arguments;
        }

        public Builder setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public <T> Builder setWorkflowType(Class<T> workflowInterface) {
            POJOWorkflowInterfaceMetadata workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterface, true);
            this.workflowType = workflowMetadata.getWorkflowType().get();
            return this;
        }

        public Builder setOptions(WorkflowOptions options) {
            this.options = options;
            return this;
        }

        public Builder setHeader(Header header) {
            this.header = header;
            return this;
        }

        public Builder setRawArguments(EncodedValues values) {
            this.arguments = values;
            return this;
        }

        public Builder setArguments(Object ... arguments) {
            this.arguments = new EncodedValues(arguments);
            return this;
        }

        public ScheduleActionStartWorkflow build() {
            return new ScheduleActionStartWorkflow(this.workflowType, this.options, this.header == null ? Header.empty() : this.header, this.arguments);
        }
    }
}

