/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.client.schedules.ScheduleBackfill;
import java.util.List;
import java.util.Map;

public final class ScheduleOptions {
    private final boolean triggerImmediately;
    private final List<ScheduleBackfill> backfills;
    private final Map<String, Object> memo;
    private final Map<String, ?> searchAttributes;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ScheduleOptions options) {
        return new Builder(options);
    }

    private ScheduleOptions(boolean triggerImmediately, List<ScheduleBackfill> backfills, Map<String, Object> memo, Map<String, ?> searchAttributes) {
        this.triggerImmediately = triggerImmediately;
        this.backfills = backfills;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
    }

    public boolean isTriggerImmediately() {
        return this.triggerImmediately;
    }

    public List<ScheduleBackfill> getBackfills() {
        return this.backfills;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    public Map<String, ?> getSearchAttributes() {
        return this.searchAttributes;
    }

    public static final class Builder {
        private boolean triggerImmediately;
        private List<ScheduleBackfill> backfills;
        private Map<String, Object> memo;
        private Map<String, ?> searchAttributes;

        private Builder() {
        }

        private Builder(ScheduleOptions options) {
            if (options == null) {
                return;
            }
            this.triggerImmediately = options.triggerImmediately;
            this.backfills = options.backfills;
            this.memo = options.memo;
            this.searchAttributes = options.searchAttributes;
        }

        public Builder setTriggerImmediately(boolean triggerImmediately) {
            this.triggerImmediately = triggerImmediately;
            return this;
        }

        public Builder setBackfills(List<ScheduleBackfill> backfills) {
            this.backfills = backfills;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        public Builder setSearchAttributes(Map<String, ?> searchAttributes) {
            this.searchAttributes = searchAttributes;
            return this;
        }

        public ScheduleOptions build() {
            return new ScheduleOptions(this.triggerImmediately, this.backfills, this.memo, this.searchAttributes);
        }
    }
}

