/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.common.collect.Iterators;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.schedule.v1.BackfillRequest;
import io.temporal.api.schedule.v1.ScheduleListEntry;
import io.temporal.api.schedule.v1.SchedulePatch;
import io.temporal.api.schedule.v1.TriggerImmediatelyRequest;
import io.temporal.api.workflowservice.v1.CreateScheduleRequest;
import io.temporal.api.workflowservice.v1.DeleteScheduleRequest;
import io.temporal.api.workflowservice.v1.DescribeScheduleRequest;
import io.temporal.api.workflowservice.v1.DescribeScheduleResponse;
import io.temporal.api.workflowservice.v1.PatchScheduleRequest;
import io.temporal.api.workflowservice.v1.UpdateScheduleRequest;
import io.temporal.client.ListScheduleListDescriptionIterator;
import io.temporal.client.schedules.ScheduleAlreadyRunningException;
import io.temporal.client.schedules.ScheduleBackfill;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.client.schedules.ScheduleDescription;
import io.temporal.client.schedules.ScheduleUpdate;
import io.temporal.client.schedules.ScheduleUpdateInput;
import io.temporal.common.interceptors.ScheduleClientCallsInterceptor;
import io.temporal.internal.client.ScheduleProtoUtil;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.SearchAttributesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootScheduleClientInvoker
implements ScheduleClientCallsInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RootScheduleClientInvoker.class);
    private final GenericWorkflowClient genericClient;
    private final ScheduleClientOptions clientOptions;
    private final ScheduleProtoUtil scheduleRequestHeader;

    public RootScheduleClientInvoker(GenericWorkflowClient genericClient, ScheduleClientOptions clientOptions) {
        this.genericClient = genericClient;
        this.clientOptions = clientOptions;
        this.scheduleRequestHeader = new ScheduleProtoUtil(genericClient, clientOptions);
    }

    @Override
    public void createSchedule(ScheduleClientCallsInterceptor.CreateScheduleInput input) {
        block7: {
            CreateScheduleRequest.Builder request = CreateScheduleRequest.newBuilder().setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setRequestId(UUID.randomUUID().toString()).setScheduleId(input.getId()).setSchedule(this.scheduleRequestHeader.scheduleToProto(input.getSchedule()));
            if (input.getOptions().getMemo() != null) {
                request.setMemo(Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(this.clientOptions.getDataConverter(), input.getOptions().getMemo())));
            }
            if (input.getOptions().getSearchAttributes() != null && !input.getOptions().getSearchAttributes().isEmpty()) {
                request.setSearchAttributes(SearchAttributesUtil.encode(input.getOptions().getSearchAttributes()));
            }
            if (input.getOptions().isTriggerImmediately() || input.getOptions().getBackfills() != null && input.getOptions().getBackfills().size() > 0) {
                SchedulePatch.Builder patchBuilder = SchedulePatch.newBuilder();
                if (input.getOptions().getBackfills() != null) {
                    input.getOptions().getBackfills().stream().forEach(b -> patchBuilder.addBackfillRequest(this.backfillToProto((ScheduleBackfill)b)));
                }
                if (input.getOptions().isTriggerImmediately()) {
                    patchBuilder.setTriggerImmediately(TriggerImmediatelyRequest.newBuilder().setOverlapPolicy(input.getSchedule().getPolicy().getOverlap()).build());
                }
                request.setInitialPatch(patchBuilder.build());
            }
            try {
                this.genericClient.createSchedule(request.build());
            }
            catch (Exception e) {
                StatusRuntimeException sre;
                if (!(e instanceof StatusRuntimeException) || !Status.Code.ALREADY_EXISTS.equals((Object)(sre = (StatusRuntimeException)((Object)e)).getStatus().getCode())) break block7;
                throw new ScheduleAlreadyRunningException(sre);
            }
        }
    }

    @Override
    public ScheduleClientCallsInterceptor.ListScheduleOutput listSchedules(ScheduleClientCallsInterceptor.ListSchedulesInput input) {
        ListScheduleListDescriptionIterator iterator = new ListScheduleListDescriptionIterator(this.clientOptions.getNamespace(), input.getPageSize(), this.genericClient);
        iterator.init();
        Iterator wrappedIterator = Iterators.transform((Iterator)iterator, entry -> this.scheduleRequestHeader.protoToScheduleListDescription((ScheduleListEntry)entry));
        int CHARACTERISTICS = 1297;
        return new ScheduleClientCallsInterceptor.ListScheduleOutput(StreamSupport.stream(Spliterators.spliteratorUnknownSize(wrappedIterator, 1297), false));
    }

    public BackfillRequest backfillToProto(ScheduleBackfill backfill) {
        return BackfillRequest.newBuilder().setStartTime(ProtobufTimeUtils.toProtoTimestamp(backfill.getStartAt())).setEndTime(ProtobufTimeUtils.toProtoTimestamp(backfill.getEndAt())).setOverlapPolicy(backfill.getOverlapPolicy()).build();
    }

    @Override
    public void backfillSchedule(ScheduleClientCallsInterceptor.BackfillScheduleInput input) {
        ArrayList<BackfillRequest> backfillRequests = new ArrayList<BackfillRequest>(input.getBackfills().size());
        for (ScheduleBackfill backfill : input.getBackfills()) {
            backfillRequests.add(this.backfillToProto(backfill));
        }
        SchedulePatch patch = SchedulePatch.newBuilder().addAllBackfillRequest(backfillRequests).build();
        PatchScheduleRequest request = PatchScheduleRequest.newBuilder().setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setScheduleId(input.getScheduleId()).setPatch(patch).build();
        this.genericClient.patchSchedule(request);
    }

    @Override
    public void deleteSchedule(ScheduleClientCallsInterceptor.DeleteScheduleInput input) {
        DeleteScheduleRequest request = DeleteScheduleRequest.newBuilder().setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setScheduleId(input.getScheduleId()).build();
        this.genericClient.deleteSchedule(request);
    }

    @Override
    public ScheduleClientCallsInterceptor.DescribeScheduleOutput describeSchedule(ScheduleClientCallsInterceptor.DescribeScheduleInput input) {
        DescribeScheduleRequest request = DescribeScheduleRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setScheduleId(input.getScheduleId()).build();
        DescribeScheduleResponse response = this.genericClient.describeSchedule(request);
        return new ScheduleClientCallsInterceptor.DescribeScheduleOutput(new ScheduleDescription(input.getScheduleId(), this.scheduleRequestHeader.protoToScheduleInfo(response.getInfo()), this.scheduleRequestHeader.protoToSchedule(response.getSchedule()), Collections.unmodifiableMap(SearchAttributesUtil.decode(response.getSearchAttributes())), response.getMemo().getFieldsMap(), this.clientOptions.getDataConverter()));
    }

    @Override
    public void pauseSchedule(ScheduleClientCallsInterceptor.PauseScheduleInput input) {
        SchedulePatch patch = SchedulePatch.newBuilder().setPause(input.getNote()).build();
        PatchScheduleRequest request = PatchScheduleRequest.newBuilder().setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setScheduleId(input.getScheduleId()).setPatch(patch).build();
        this.genericClient.patchSchedule(request);
    }

    @Override
    public void triggerSchedule(ScheduleClientCallsInterceptor.TriggerScheduleInput input) {
        TriggerImmediatelyRequest trigger = TriggerImmediatelyRequest.newBuilder().setOverlapPolicy(input.getOverlapPolicy()).build();
        SchedulePatch patch = SchedulePatch.newBuilder().setTriggerImmediately(trigger).build();
        PatchScheduleRequest request = PatchScheduleRequest.newBuilder().setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setScheduleId(input.getScheduleId()).setPatch(patch).build();
        this.genericClient.patchSchedule(request);
    }

    @Override
    public void unpauseSchedule(ScheduleClientCallsInterceptor.UnpauseScheduleInput input) {
        SchedulePatch patch = SchedulePatch.newBuilder().setUnpause(input.getNote()).build();
        PatchScheduleRequest request = PatchScheduleRequest.newBuilder().setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setScheduleId(input.getScheduleId()).setPatch(patch).build();
        this.genericClient.patchSchedule(request);
    }

    @Override
    public void updateSchedule(ScheduleClientCallsInterceptor.UpdateScheduleInput input) {
        ScheduleUpdate schedule = input.getUpdater().apply(new ScheduleUpdateInput(input.getDescription()));
        if (schedule == null) {
            return;
        }
        UpdateScheduleRequest request = UpdateScheduleRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity()).setScheduleId(input.getDescription().getId()).setRequestId(UUID.randomUUID().toString()).setSchedule(this.scheduleRequestHeader.scheduleToProto(schedule.getSchedule())).build();
        this.genericClient.updateSchedule(request);
    }
}

