/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.ProtocolMessageCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.protocol.v1.Message;
import io.temporal.api.update.v1.Acceptance;
import io.temporal.api.update.v1.Meta;
import io.temporal.api.update.v1.Outcome;
import io.temporal.api.update.v1.Rejection;
import io.temporal.api.update.v1.Request;
import io.temporal.api.update.v1.Response;
import io.temporal.internal.common.ProtocolType;
import io.temporal.internal.common.UpdateMessage;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.UpdateProtocolCallback;
import io.temporal.workflow.Functions;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UpdateProtocolStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, UpdateProtocolStateMachine> {
    private static final Logger log = LoggerFactory.getLogger(UpdateProtocolStateMachine.class);
    private final Functions.Func<Boolean> replaying;
    private final Functions.Proc1<UpdateMessage> updateHandle;
    private final Functions.Proc1<Message> sendHandle;
    private String protoInstanceID;
    private String requestMsgId;
    private long requestSeqID;
    private Meta meta;
    private String messageId;
    public static final StateMachineDefinition<State, ExplicitEvent, UpdateProtocolStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("Update", State.NEW, State.COMPLETED_COMMAND_RECORDED).add(State.NEW, ProtocolType.UPDATE_V1, State.REQUEST_INITIATED, UpdateProtocolStateMachine::triggerUpdate).add(State.REQUEST_INITIATED, ExplicitEvent.ACCEPT, State.ACCEPTED, UpdateProtocolStateMachine::sendCommandMessage).add(State.ACCEPTED, CommandType.COMMAND_TYPE_PROTOCOL_MESSAGE, State.ACCEPTED_COMMAND_CREATED).add(State.ACCEPTED_COMMAND_CREATED, EventType.EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_ACCEPTED, State.ACCEPTED_COMMAND_RECORDED).add(State.ACCEPTED_COMMAND_RECORDED, ExplicitEvent.COMPLETE, State.COMPLETED, UpdateProtocolStateMachine::sendCommandMessage).add(State.COMPLETED, CommandType.COMMAND_TYPE_PROTOCOL_MESSAGE, State.COMPLETED_COMMAND_CREATED).add(State.COMPLETED_COMMAND_CREATED, EventType.EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_COMPLETED, State.COMPLETED_COMMAND_RECORDED).add(State.REQUEST_INITIATED, ExplicitEvent.REJECT, State.COMPLETED_COMMAND_RECORDED).add(State.ACCEPTED, ExplicitEvent.COMPLETE, State.COMPLETED_IMMEDIATELY, UpdateProtocolStateMachine::sendCommandMessage).add(State.COMPLETED_IMMEDIATELY, CommandType.COMMAND_TYPE_PROTOCOL_MESSAGE, State.COMPLETED_IMMEDIATELY_COMMAND_CREATED).add(State.COMPLETED_IMMEDIATELY_COMMAND_CREATED, CommandType.COMMAND_TYPE_PROTOCOL_MESSAGE, State.COMPLETED_IMMEDIATELY_COMMAND_RECORDED).add(State.COMPLETED_IMMEDIATELY_COMMAND_RECORDED, EventType.EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_ACCEPTED, State.COMPLETED_COMMAND_CREATED).add(State.ACCEPTED_COMMAND_CREATED, ExplicitEvent.COMPLETE, State.COMPLETED_IMMEDIATELY_COMMAND_CREATED, UpdateProtocolStateMachine::sendCommandMessage);

    public static UpdateProtocolStateMachine newInstance(Functions.Func<Boolean> replaying, Functions.Proc1<UpdateMessage> updateHandle, Functions.Proc1<Message> sendHandle, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new UpdateProtocolStateMachine(replaying, updateHandle, sendHandle, commandSink, stateMachineSink);
    }

    private UpdateProtocolStateMachine(Functions.Func<Boolean> replaying, Functions.Proc1<UpdateMessage> updateHandle, Functions.Proc1<Message> sendHandle, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.replaying = replaying;
        this.updateHandle = updateHandle;
        this.sendHandle = sendHandle;
    }

    void triggerUpdate() {
        this.protoInstanceID = this.currentMessage.getProtocolInstanceId();
        this.requestMsgId = this.currentMessage.getId();
        this.requestSeqID = this.currentMessage.getEventId();
        try {
            this.meta = ((Request)this.currentMessage.getBody().unpack(Request.class)).getMeta();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Current message not an update:" + this.currentMessage);
        }
        UpdateMessage updateMessage = new UpdateMessage(this.currentMessage, new UpdateProtocolCallbackImpl());
        this.updateHandle.apply(updateMessage);
    }

    void sendCommandMessage() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_PROTOCOL_MESSAGE).setProtocolMessageCommandAttributes(ProtocolMessageCommandAttributes.newBuilder().setMessageId(this.messageId)).build());
    }

    public void accept() {
        Acceptance acceptResponse = Acceptance.newBuilder().setAcceptedRequestMessageId(this.requestMsgId).setAcceptedRequestSequencingEventId(this.requestSeqID).build();
        this.messageId = this.requestMsgId + "/accept";
        this.sendHandle.apply(Message.newBuilder().setId(this.messageId).setProtocolInstanceId(this.protoInstanceID).setBody(Any.pack((com.google.protobuf.Message)acceptResponse)).build());
        this.explicitEvent(ExplicitEvent.ACCEPT);
    }

    public void reject(Failure failure) {
        Rejection rejectResponse = Rejection.newBuilder().setRejectedRequestMessageId(this.requestMsgId).setRejectedRequestSequencingEventId(this.requestSeqID).setFailure(failure).build();
        String messageId = this.requestMsgId + "/reject";
        this.sendHandle.apply(Message.newBuilder().setId(messageId).setProtocolInstanceId(this.protoInstanceID).setBody(Any.pack((com.google.protobuf.Message)rejectResponse)).build());
        this.explicitEvent(ExplicitEvent.REJECT);
    }

    public void complete(Optional<Payloads> payload, Failure failure) {
        Outcome.Builder outcome = Outcome.newBuilder();
        outcome = failure != null ? outcome.setFailure(failure) : outcome.setSuccess(payload.isPresent() ? payload.get() : null);
        Response outcomeResponse = Response.newBuilder().setOutcome(outcome).setMeta(this.meta).build();
        this.messageId = this.requestMsgId + "/complete";
        this.sendHandle.apply(Message.newBuilder().setId(this.messageId).setProtocolInstanceId(this.protoInstanceID).setBody(Any.pack((com.google.protobuf.Message)outcomeResponse)).build());
        this.explicitEvent(ExplicitEvent.COMPLETE);
    }

    @Override
    public void handleMessage(Message message) {
        if (this.getState() == State.NEW) {
            super.handleMessage(message);
        } else if (log.isWarnEnabled()) {
            log.warn("Received duplicate update messages for protocol instance: " + message.getProtocolInstanceId());
        }
    }

    private class UpdateProtocolCallbackImpl
    implements UpdateProtocolCallback {
        private UpdateProtocolCallbackImpl() {
        }

        @Override
        public void accept() {
            UpdateProtocolStateMachine.this.accept();
        }

        @Override
        public void reject(Failure failure) {
            UpdateProtocolStateMachine.this.reject(failure);
        }

        @Override
        public void complete(Optional<Payloads> result, Failure failure) {
            UpdateProtocolStateMachine.this.complete(result, failure);
        }

        @Override
        public boolean isReplaying() {
            return (Boolean)UpdateProtocolStateMachine.this.replaying.apply();
        }
    }

    static enum State {
        NEW,
        REQUEST_INITIATED,
        ACCEPTED,
        ACCEPTED_COMMAND_CREATED,
        ACCEPTED_COMMAND_RECORDED,
        COMPLETED,
        COMPLETED_COMMAND_CREATED,
        COMPLETED_COMMAND_RECORDED,
        COMPLETED_IMMEDIATELY,
        COMPLETED_IMMEDIATELY_COMMAND_CREATED,
        COMPLETED_IMMEDIATELY_COMMAND_RECORDED;

    }

    static enum ExplicitEvent {
        REJECT,
        ACCEPT,
        COMPLETE;

    }
}

