/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.annotations.VisibleForTesting;
import io.temporal.common.MethodRetry;
import io.temporal.common.metadata.POJOActivityInterfaceMetadata;
import io.temporal.common.metadata.POJOActivityMethodMetadata;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.AsyncInternal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;

@VisibleForTesting
public abstract class ActivityInvocationHandlerBase
implements InvocationHandler {
    private final POJOActivityInterfaceMetadata activityMetadata;

    protected ActivityInvocationHandlerBase(Class<?> activityInterface) {
        this.activityMetadata = POJOActivityInterfaceMetadata.newInstance(activityInterface);
    }

    @VisibleForTesting
    public static <T> T newProxy(Class<T> activityInterface, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(activityInterface.getClassLoader(), new Class[]{activityInterface, AsyncInternal.AsyncMarker.class}, invocationHandler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        POJOActivityMethodMetadata methodMetadata = this.activityMetadata.getMethodMetadata(method);
        MethodRetry methodRetry = methodMetadata.getMethod().getAnnotation(MethodRetry.class);
        String activityType = methodMetadata.getActivityTypeName();
        Function<Object[], Object> function = this.getActivityFunc(method, methodRetry, activityType);
        return InternalUtils.getValueOrDefault(function.apply(args), method.getReturnType());
    }

    protected abstract Function<Object[], Object> getActivityFunc(Method var1, MethodRetry var2, String var3);
}

