/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.grpc.Deadline;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.worker.LocalActivityResult;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class LocalActivityExecutionContext {
    @Nonnull
    private final ExecuteLocalActivityParameters executionParams;
    @Nonnull
    private final AtomicInteger currentAttempt;
    @Nonnull
    private final AtomicReference<Failure> lastAttemptFailure = new AtomicReference();
    @Nullable
    private final Deadline scheduleToCloseDeadline;
    @Nullable
    private ScheduledFuture<?> scheduleToCloseFuture;
    @Nonnull
    private final CompletableFuture<LocalActivityResult> executionResult = new CompletableFuture();
    @Nullable
    private SlotPermit permit;
    private final TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier;

    public LocalActivityExecutionContext(@Nonnull ExecuteLocalActivityParameters executionParams, @Nonnull Functions.Proc1<LocalActivityResult> resultCallback, @Nullable Deadline scheduleToCloseDeadline, TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier) {
        this.executionParams = Objects.requireNonNull(executionParams, "executionParams");
        this.executionResult.thenAccept(Objects.requireNonNull(resultCallback, "resultCallback")::apply);
        this.scheduleToCloseDeadline = scheduleToCloseDeadline;
        this.currentAttempt = new AtomicInteger(executionParams.getInitialAttempt());
        this.slotSupplier = slotSupplier;
        Failure previousExecutionFailure = executionParams.getPreviousLocalExecutionFailure();
        if (previousExecutionFailure != null) {
            if (previousExecutionFailure.hasTimeoutFailureInfo() && previousExecutionFailure.hasCause()) {
                this.lastAttemptFailure.set(Failure.newBuilder((Failure)previousExecutionFailure).clearCause().build());
            } else {
                this.lastAttemptFailure.set(previousExecutionFailure);
            }
        }
    }

    public String getActivityId() {
        return this.executionParams.getActivityId();
    }

    public int getCurrentAttempt() {
        return this.currentAttempt.get();
    }

    @Nullable
    public Failure getLastAttemptFailure() {
        return this.lastAttemptFailure.get();
    }

    @Nullable
    public Failure getPreviousExecutionFailure() {
        return this.executionParams.getPreviousLocalExecutionFailure();
    }

    @Nonnull
    public PollActivityTaskQueueResponse.Builder getInitialTask() {
        return this.executionParams.cloneActivityTaskBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public PollActivityTaskQueueResponse.Builder getNextAttemptActivityTask(@Nullable Failure lastFailure) {
        int nextAttempt;
        CompletableFuture<LocalActivityResult> completableFuture = this.executionResult;
        synchronized (completableFuture) {
            nextAttempt = this.currentAttempt.incrementAndGet();
            if (lastFailure != null) {
                this.lastAttemptFailure.set(lastFailure);
            }
        }
        return this.executionParams.cloneActivityTaskBuilder().setAttempt(nextAttempt).clearCurrentAttemptScheduledTime();
    }

    @Nullable
    public Deadline getScheduleToCloseDeadline() {
        return this.scheduleToCloseDeadline;
    }

    public void setScheduleToCloseFuture(@Nullable ScheduledFuture<?> scheduleToCloseFuture) {
        this.scheduleToCloseFuture = scheduleToCloseFuture;
    }

    @Nullable
    public Duration getScheduleToStartTimeout() {
        return this.executionParams.getScheduleToStartTimeout();
    }

    public long getOriginalScheduledTimestamp() {
        return this.executionParams.getOriginalScheduledTimestamp();
    }

    @Nonnull
    public Duration getLocalRetryThreshold() {
        return this.executionParams.getLocalRetryThreshold();
    }

    public boolean callback(LocalActivityResult result) {
        if (this.scheduleToCloseFuture != null) {
            this.scheduleToCloseFuture.cancel(false);
        }
        SlotReleaseReason reason = SlotReleaseReason.taskComplete();
        if (result.getProcessingError() != null) {
            reason = SlotReleaseReason.error(new Exception(result.getProcessingError().getThrowable()));
        }
        this.slotSupplier.releaseSlot(reason, this.permit);
        return this.executionResult.complete(result);
    }

    public boolean isCompleted() {
        return this.executionResult.isDone();
    }

    public void newAttempt() {
        this.executionParams.getOnNewAttemptCallback().apply();
    }

    public void setPermit(SlotPermit permit) {
        this.permit = permit;
    }

    @Nullable
    public SlotPermit getPermit() {
        return this.permit;
    }
}

