/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.common.Experimental;
import javax.annotation.Nullable;

@Experimental
public abstract class SlotReleaseReason {
    SlotReleaseReason() {
    }

    public static SlotReleaseReason taskComplete() {
        return new TaskComplete();
    }

    public static SlotReleaseReason neverUsed() {
        return new NeverUsed();
    }

    public static SlotReleaseReason error(Exception exception) {
        return new Error(exception);
    }

    public boolean isError() {
        return false;
    }

    @Nullable
    public Exception getException() {
        return null;
    }

    public static class Error
    extends SlotReleaseReason {
        private final Exception exception;

        private Error(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }
    }

    public static class NeverUsed
    extends SlotReleaseReason {
    }

    public static class TaskComplete
    extends SlotReleaseReason {
    }
}

