/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class WorkflowClientHelper {
    public static Iterator<HistoryEvent> getHistory(final WorkflowServiceStubs service, final String namespace, final WorkflowExecution workflowExecution, final Scope metricsScope) {
        return new Iterator<HistoryEvent>(){
            ByteString nextPageToken = ByteString.EMPTY;
            Iterator<HistoryEvent> current;
            {
                this.getNextPage();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext() || !this.nextPageToken.isEmpty();
            }

            @Override
            public HistoryEvent next() {
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                this.getNextPage();
                return this.current.next();
            }

            private void getNextPage() {
                GetWorkflowExecutionHistoryResponse history = WorkflowClientHelper.getHistoryPage(service, namespace, workflowExecution, this.nextPageToken, metricsScope);
                this.current = history.getHistory().getEventsList().iterator();
                this.nextPageToken = history.getNextPageToken();
            }
        };
    }

    public static GetWorkflowExecutionHistoryResponse getHistoryPage(WorkflowServiceStubs service, String namespace, WorkflowExecution workflowExecution, ByteString nextPageToken, Scope metricsScope) {
        GetWorkflowExecutionHistoryRequest getHistoryRequest = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(namespace).setExecution(workflowExecution).setNextPageToken(nextPageToken).build();
        return ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).getWorkflowExecutionHistory(getHistoryRequest);
    }

    public static WorkflowExecutionInfo describeWorkflowInstance(WorkflowServiceStubs service, String namespace, WorkflowExecution workflowExecution, @Nullable Scope metricsScope) {
        DescribeWorkflowExecutionRequest describeRequest = DescribeWorkflowExecutionRequest.newBuilder().setNamespace(namespace).setExecution(workflowExecution).build();
        WorkflowServiceGrpc.WorkflowServiceBlockingStub stub = (WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub();
        if (metricsScope != null) {
            stub = (WorkflowServiceGrpc.WorkflowServiceBlockingStub)stub.withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope);
        }
        DescribeWorkflowExecutionResponse executionDetail = stub.describeWorkflowExecution(describeRequest);
        WorkflowExecutionInfo instanceMetadata = executionDetail.getWorkflowExecutionInfo();
        return instanceMetadata;
    }
}

