/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.common.NonIdempotentHandle;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowThreadContext;
import io.temporal.internal.sync.WorkflowThreadLocalInternal;
import io.temporal.workflow.CancellationScope;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public interface WorkflowThread
extends CancellationScope {
    public static void await(String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        DeterministicRunnerImpl.currentThreadInternal().yield(reason, unblockCondition);
    }

    public static WorkflowThread newThread(Runnable runnable, boolean detached) {
        return WorkflowThread.newThread(runnable, detached, null);
    }

    public static WorkflowThread newThread(Runnable runnable, boolean detached, String name) {
        return (WorkflowThread)DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext().getWorkflowOutboundInterceptor().newChildThread(runnable, detached, name);
    }

    public void start();

    public boolean isStarted();

    public void setName(String var1);

    public String getName();

    public long getId();

    public int getPriority();

    public String getStackTrace();

    public DeterministicRunnerImpl getRunner();

    public SyncWorkflowContext getWorkflowContext();

    public boolean runUntilBlocked(long var1);

    public NonIdempotentHandle lockDeadlockDetector();

    public Throwable getUnhandledException();

    public boolean isDone();

    public Future<?> stopNow();

    public void addStackTrace(StringBuilder var1);

    public void yield(String var1, Supplier<Boolean> var2) throws DestroyWorkflowThreadError;

    public static void exit() {
        DeterministicRunnerImpl.currentThreadInternal().exitThread();
    }

    public void exitThread();

    public <T> void setThreadLocal(WorkflowThreadLocalInternal<T> var1, T var2);

    public <T> Optional<Optional<T>> getThreadLocal(WorkflowThreadLocalInternal<T> var1);

    public WorkflowThreadContext getWorkflowThreadContext();
}

